/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class EdgesVerticesMap {
    public static final String DIRECTION = Tokens.makeNamespace(EdgesVerticesMap.class) + ".direction";

    public static Configuration createConfiguration(Direction direction) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(DIRECTION, direction.name());
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private Direction direction;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.direction = Direction.valueOf((String)context.getConfiguration().get(DIRECTION));
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            HadoopEdge edge;
            HadoopEdge edge2;
            long edgesProcessed;
            if (this.direction.equals((Object)Direction.IN) || this.direction.equals((Object)Direction.BOTH)) {
                edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.IN)) {
                    edge2 = (HadoopEdge)e;
                    if (!edge2.hasPaths()) continue;
                    value.getPaths(edge2, true);
                    ++edgesProcessed;
                    edge2.clearPaths();
                }
                context.getCounter((Enum)Counters.IN_EDGES_PROCESSED).increment(edgesProcessed);
            } else {
                for (Edge e : value.getEdges(Direction.IN)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            if (this.direction.equals((Object)Direction.OUT) || this.direction.equals((Object)Direction.BOTH)) {
                edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    edge2 = (HadoopEdge)e;
                    if (!edge2.hasPaths()) continue;
                    value.getPaths(edge2, true);
                    ++edgesProcessed;
                    edge2.clearPaths();
                }
                context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            } else {
                for (Edge e : value.getEdges(Direction.OUT)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        IN_EDGES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

