/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class EdgesMap {
    public static final String PROCESS_VERTICES = Tokens.makeNamespace(EdgesMap.class) + ".processVertices";

    public static Configuration createConfiguration(boolean processVertices) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setBoolean(PROCESS_VERTICES, processVertices);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean processVertices;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.processVertices = context.getConfiguration().getBoolean(PROCESS_VERTICES, true);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.processVertices) {
                value.clearPaths();
                context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
            }
            long edgesProcessed = 0L;
            for (Edge edge : value.getEdges(Direction.IN)) {
                ((HadoopEdge)edge).startPath();
                ++edgesProcessed;
            }
            context.getCounter((Enum)Counters.IN_EDGES_PROCESSED).increment(edgesProcessed);
            edgesProcessed = 0L;
            for (Edge edge : value.getEdges(Direction.OUT)) {
                ((HadoopEdge)edge).startPath();
                ++edgesProcessed;
            }
            context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        OUT_EDGES_PROCESSED,
        IN_EDGES_PROCESSED;

    }
}

