/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import groovy.lang.Closure;
import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class SideEffectMap {
    public static final String CLASS = Tokens.makeNamespace(SideEffectMap.class) + ".class";
    public static final String CLOSURE = Tokens.makeNamespace(SideEffectMap.class) + ".closure";
    private static final ScriptEngine engine = new GremlinGroovyScriptEngine();

    public static Configuration createConfiguration(Class<? extends Element> klass, String closure) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(CLOSURE, closure);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private Closure closure;
        private boolean isVertex;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            try {
                this.closure = (Closure)engine.eval(context.getConfiguration().get(CLOSURE));
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    this.closure.call((Object)value);
                    context.getCounter((Enum)Counters.VERTICES_PROCESSED).increment(1L);
                }
            } else {
                HadoopEdge edge;
                long edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.IN)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    ++edgesProcessed;
                    this.closure.call((Object)edge);
                }
                context.getCounter((Enum)Counters.IN_EDGES_PROCESSED).increment(edgesProcessed);
                edgesProcessed = 0L;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    ++edgesProcessed;
                    this.closure.call((Object)edge);
                }
                context.getCounter((Enum)Counters.OUT_EDGES_PROCESSED).increment(edgesProcessed);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED,
        IN_EDGES_PROCESSED,
        OUT_EDGES_PROCESSED;

    }
}

