/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.sideeffect;

import com.thinkaurelius.titan.hadoop.ElementState;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class CommitVerticesMapReduce {
    public static final String ACTION = Tokens.makeNamespace(CommitVerticesMapReduce.class) + ".action";

    public static Configuration createConfiguration(Tokens.Action action) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.set(ACTION, action.name());
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, HadoopVertex> {
        private boolean trackState;

        public void setup(Reducer.Context context) {
            this.trackState = context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-state", false);
        }

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = null;
            HashSet<Long> ids = new HashSet<Long>();
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'k') {
                    ids.add(((HadoopElement)holder.get()).getIdAsLong());
                    continue;
                }
                if (tag == 'v') {
                    vertex = (HadoopVertex)holder.get();
                    continue;
                }
                vertex = (HadoopVertex)holder.get();
                vertex.setState(ElementState.DELETED);
                Iterator<Edge> itty = vertex.getEdges(Direction.BOTH).iterator();
                while (itty.hasNext()) {
                    itty.next();
                    itty.remove();
                }
            }
            if (null != vertex) {
                if (ids.size() > 0) {
                    vertex.removeEdgesToFrom(ids);
                }
                if (this.trackState) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                } else if (!vertex.isDeleted()) {
                    context.write((Object)NullWritable.get(), (Object)vertex);
                }
                context.getCounter((Enum)Counters.OUT_EDGES_KEPT).increment((long)((List)vertex.getEdges(Direction.OUT)).size());
                context.getCounter((Enum)Counters.IN_EDGES_KEPT).increment((long)((List)vertex.getEdges(Direction.IN)).size());
            }
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private final Holder<HadoopVertex> holder = new Holder();

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = null;
            HashSet<Long> ids = new HashSet<Long>();
            boolean isDeleted = false;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'k') {
                    ids.add(((HadoopElement)holder.get()).getIdAsLong());
                    continue;
                }
                vertex = (HadoopVertex)holder.get();
                isDeleted = tag == 'd';
            }
            if (null != vertex) {
                if (ids.size() > 0) {
                    vertex.removeEdgesToFrom(ids);
                }
                context.write((Object)key, this.holder.set(isDeleted ? (char)'d' : 'v', vertex));
            } else {
                for (Long id : ids) {
                    context.write((Object)key, this.holder.set('k', new HadoopVertex(context.getConfiguration(), id)));
                }
            }
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder> {
        private boolean drop;
        private final Holder<HadoopVertex> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.drop = Tokens.Action.valueOf(context.getConfiguration().get(ACTION)).equals((Object)Tokens.Action.DROP);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            boolean keep;
            boolean hasPaths = value.hasPaths();
            long verticesKept = 0L;
            long verticesDropped = 0L;
            if (this.drop && hasPaths) {
                keep = false;
            } else if (!this.drop && hasPaths) {
                keep = true;
            } else {
                boolean bl = keep = this.drop && !hasPaths;
            }
            if (keep) {
                this.longWritable.set(value.getIdAsLong());
                context.write((Object)this.longWritable, this.holder.set('v', value));
                ++verticesKept;
            } else {
                Long id;
                long vertexId = value.getIdAsLong();
                this.holder.set('k', new HadoopVertex(context.getConfiguration(), vertexId));
                for (Edge edge : value.getEdges(Direction.OUT)) {
                    id = (Long)edge.getVertex(Direction.IN).getId();
                    if (id.equals(vertexId)) continue;
                    this.longWritable.set(id.longValue());
                    context.write((Object)this.longWritable, this.holder);
                }
                for (Edge edge : value.getEdges(Direction.IN)) {
                    id = (Long)edge.getVertex(Direction.OUT).getId();
                    if (id.equals(vertexId)) continue;
                    this.longWritable.set(id.longValue());
                    context.write((Object)this.longWritable, this.holder);
                }
                this.longWritable.set(value.getIdAsLong());
                context.write((Object)this.longWritable, this.holder.set('d', value));
                ++verticesDropped;
            }
            context.getCounter((Enum)Counters.VERTICES_DROPPED).increment(verticesDropped);
            context.getCounter((Enum)Counters.VERTICES_KEPT).increment(verticesKept);
        }
    }

    public static enum Counters {
        VERTICES_KEPT,
        VERTICES_DROPPED,
        OUT_EDGES_KEPT,
        IN_EDGES_KEPT;

    }
}

