/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.ElementChecker;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class PropertyFilterMap {
    public static final String CLASS = Tokens.makeNamespace(PropertyFilterMap.class) + ".class";
    public static final String KEY = Tokens.makeNamespace(PropertyFilterMap.class) + ".key";
    public static final String VALUES = Tokens.makeNamespace(PropertyFilterMap.class) + ".values";
    public static final String VALUE_CLASS = Tokens.makeNamespace(PropertyFilterMap.class) + ".valueClass";
    public static final String COMPARE = Tokens.makeNamespace(PropertyFilterMap.class) + ".compare";

    public static Configuration createConfiguration(Class<? extends Element> klass, String key, Compare compare, Object ... values) {
        String[] valueStrings = new String[values.length];
        Class valueClass = null;
        for (int i = 0; i < values.length; ++i) {
            String string = valueStrings[i] = null == values[i] ? (valueStrings[i] = null) : values[i].toString();
            if (null == values[i]) continue;
            valueClass = values[i].getClass();
        }
        if (null == valueClass) {
            valueClass = Object.class;
        }
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(KEY, key);
        configuration.set(COMPARE, compare.name());
        configuration.setStrings(VALUES, valueStrings);
        configuration.setClass(VALUE_CLASS, valueClass, valueClass);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean isVertex;
        private ElementChecker elementChecker;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            int i;
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            String key = context.getConfiguration().get(KEY);
            Class valueClass = context.getConfiguration().getClass(VALUE_CLASS, String.class);
            String[] valueStrings = context.getConfiguration().getStrings(VALUES);
            Object[] values = new Object[valueStrings.length];
            if (valueClass.equals(Object.class)) {
                for (i = 0; i < valueStrings.length; ++i) {
                    values[i] = null;
                }
            } else if (valueClass.equals(String.class)) {
                for (i = 0; i < valueStrings.length; ++i) {
                    values[i] = valueStrings[i].equals("null") ? null : valueStrings[i];
                }
            } else if (Number.class.isAssignableFrom(valueClass)) {
                for (i = 0; i < valueStrings.length; ++i) {
                    values[i] = valueStrings[i].equals("null") ? null : Float.valueOf(valueStrings[i]);
                }
            } else if (valueClass.equals(Boolean.class)) {
                for (i = 0; i < valueStrings.length; ++i) {
                    values[i] = valueStrings[i].equals("null") ? null : Boolean.valueOf(valueStrings[i]);
                }
            } else {
                throw new IOException("Class " + valueClass + " is an unsupported value class");
            }
            Compare compare = Compare.valueOf((String)context.getConfiguration().get(COMPARE));
            this.elementChecker = new ElementChecker(key, compare, values);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths() && !this.elementChecker.isLegal(value)) {
                    value.clearPaths();
                    context.getCounter((Enum)Counters.VERTICES_FILTERED).increment(1L);
                }
            } else {
                long edgesFiltered = 0L;
                for (Edge e : value.getEdges(Direction.BOTH)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths() || this.elementChecker.isLegal(edge)) continue;
                    edge.clearPaths();
                    ++edgesFiltered;
                }
                context.getCounter((Enum)Counters.EDGES_FILTERED).increment(edgesFiltered);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_FILTERED,
        EDGES_FILTERED;

    }
}

