/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import groovy.lang.Closure;
import java.io.IOException;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class FilterMap {
    public static final String CLASS = Tokens.makeNamespace(FilterMap.class) + ".class";
    public static final String CLOSURE = Tokens.makeNamespace(FilterMap.class) + ".closure";
    private static final ScriptEngine engine = new GremlinGroovyScriptEngine();

    public static Configuration createConfiguration(Class<? extends Element> klass, String closure) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.set(CLOSURE, closure);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean isVertex;
        private Closure<Boolean> closure;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            try {
                this.closure = (Closure)engine.eval(context.getConfiguration().get(CLOSURE));
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths() && !((Boolean)this.closure.call((Object)value)).booleanValue()) {
                    value.clearPaths();
                    context.getCounter((Enum)Counters.VERTICES_FILTERED).increment(1L);
                }
            } else {
                long counter = 0L;
                for (Edge e : value.getEdges(Direction.BOTH)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths() || ((Boolean)this.closure.call((Object)edge)).booleanValue()) continue;
                    edge.clearPaths();
                    ++counter;
                }
                context.getCounter((Enum)Counters.EDGES_FILTERED).increment(counter);
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        VERTICES_FILTERED,
        EDGES_FILTERED;

    }
}

