/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;

public class CyclicPathFilterMap {
    public static final String CLASS = Tokens.makeNamespace(CyclicPathFilterMap.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        configuration.setBoolean("titan.hadoop.pipeline.track-paths", true);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        private boolean isVertex;
        private HashSet set = new HashSet();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long pathsFiltered = 0L;
            if (this.isVertex) {
                if (value.hasPaths()) {
                    Iterator<List<HadoopPathElement.MicroElement>> itty = value.getPaths().iterator();
                    while (itty.hasNext()) {
                        List<HadoopPathElement.MicroElement> path = itty.next();
                        this.set.clear();
                        this.set.addAll(path);
                        if (path.size() == this.set.size()) continue;
                        itty.remove();
                        ++pathsFiltered;
                    }
                }
            } else {
                for (Edge e : value.getEdges(Direction.BOTH)) {
                    HadoopEdge edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    Iterator<List<HadoopPathElement.MicroElement>> itty = edge.getPaths().iterator();
                    while (itty.hasNext()) {
                        List<HadoopPathElement.MicroElement> path = itty.next();
                        this.set.clear();
                        this.set.addAll(path);
                        if (path.size() == this.set.size()) continue;
                        itty.remove();
                        ++pathsFiltered;
                    }
                }
            }
            context.getCounter((Enum)Counters.PATHS_FILTERED).increment(pathsFiltered);
            context.write((Object)NullWritable.get(), (Object)value);
        }
    }

    public static enum Counters {
        PATHS_FILTERED;

    }
}

