/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.filter;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class BackFilterMapReduce {
    public static final String CLASS = Tokens.makeNamespace(BackFilterMapReduce.class) + ".class";
    public static final String STEP = Tokens.makeNamespace(BackFilterMapReduce.class) + ".step";

    public static Configuration createConfiguration(Class<? extends Element> klass, int step) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setInt(STEP, step);
        configuration.setClass(CLASS, klass, Element.class);
        configuration.setBoolean("titan.hadoop.pipeline.track-paths", true);
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder, NullWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((HadoopElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((HadoopElement)holder.get(), false);
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
        }
    }

    public static class Combiner
    extends Reducer<LongWritable, Holder, LongWritable, Holder> {
        private final Holder<HadoopVertex> holder = new Holder();

        public void reduce(LongWritable key, Iterable<Holder> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            int outTag = 120;
            for (Holder holder : values) {
                char tag = holder.getTag();
                if (tag == 'v') {
                    vertex.addAll((HadoopVertex)holder.get());
                    outTag = 118;
                    continue;
                }
                if (tag == 'p') {
                    vertex.getPaths((HadoopElement)holder.get(), true);
                    continue;
                }
                vertex.getPaths((HadoopElement)holder.get(), false);
            }
            context.write((Object)key, this.holder.set((char)outTag, vertex));
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder> {
        private int step;
        private boolean isVertex;
        private final Holder<HadoopPathElement> holder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.step = context.getConfiguration().getInt(STEP, -1);
            this.isVertex = context.getConfiguration().getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                if (value.hasPaths()) {
                    for (List<HadoopPathElement.MicroElement> path : value.getPaths()) {
                        if (path.get(this.step) instanceof HadoopEdge.MicroEdge) {
                            throw new IOException("Back does not support backing up to previous edges");
                        }
                        long backElementId = path.get(this.step).getId();
                        this.longWritable.set(backElementId);
                        HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), backElementId);
                        vertex.addPath(path, false);
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                    }
                    value.clearPaths();
                }
            } else {
                HadoopEdge edge;
                for (Edge e : value.getEdges(Direction.OUT)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    for (List<HadoopPathElement.MicroElement> path : edge.getPaths()) {
                        if (path.get(this.step) instanceof HadoopEdge.MicroEdge) {
                            throw new IOException("Back does not support backing up to previous edges");
                        }
                        long backElementId = path.get(this.step).getId();
                        this.longWritable.set(backElementId);
                        HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), backElementId);
                        vertex.addPath(path, false);
                        context.write((Object)this.longWritable, this.holder.set('p', vertex));
                    }
                    edge.clearPaths();
                }
                for (Edge e : value.getEdges(Direction.IN)) {
                    edge = (HadoopEdge)e;
                    if (!edge.hasPaths()) continue;
                    edge.clearPaths();
                }
            }
            this.longWritable.set(value.getIdAsLong());
            context.write((Object)this.longWritable, this.holder.set('v', value));
        }
    }
}

