/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce;

import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopConfigKeys;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopTasks;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCompatLoader {
    private static final Logger log = LoggerFactory.getLogger(HadoopCompatLoader.class);

    public static HadoopCompiler getCompilerFor(HadoopGraph g) {
        String ver = VersionInfo.getVersion();
        String className = ver.startsWith("1.") ? "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop1Compiler" : "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop2Compiler";
        try {
            Constructor<?> ctor = Class.forName(className).getConstructor(HadoopGraph.class);
            return (HadoopCompiler)ctor.newInstance(g);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopTasks getTasks() {
        String ver = VersionInfo.getVersion();
        String className = ver.startsWith("1.") ? "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop1Tasks" : "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop2Tasks";
        try {
            return (HadoopTasks)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static HadoopConfigKeys getConfigKeys() {
        String ver = VersionInfo.getVersion();
        String className = ver.startsWith("1.") ? "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop1ConfigKeys" : "com.thinkaurelius.titan.hadoop.mapreduce.Hadoop2ConfigKeys";
        try {
            return (HadoopConfigKeys)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

