/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.hbase;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.hbase.TitanHBaseHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.titan.hbase.TitanHBaseInputFormat;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanHBaseRecordReader
extends RecordReader<NullWritable, HadoopVertex> {
    private TableRecordReader reader;
    private TitanHBaseHadoopGraph graph;
    private VertexQueryFilter vertexQuery;
    private Configuration configuration;
    private HadoopVertex vertex;

    public TitanHBaseRecordReader(TitanHBaseHadoopGraph graph, VertexQueryFilter vertexQuery, TableRecordReader reader) {
        this.graph = graph;
        this.vertexQuery = vertexQuery;
        this.reader = reader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
        this.configuration = taskAttemptContext.getConfiguration();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            HadoopVertex temp = this.graph.readHadoopVertex(this.configuration, this.reader.getCurrentKey().copyBytes(), (NavigableMap)this.reader.getCurrentValue().getMap().get(TitanHBaseInputFormat.EDGE_STORE_FAMILY));
            if (null == temp) continue;
            this.vertex = temp;
            this.vertexQuery.defaultFilter(this.vertex);
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public HadoopVertex getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        this.graph.close();
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }
}

