/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.hbase;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.TitanInputFormat;
import com.thinkaurelius.titan.hadoop.formats.titan.hbase.TitanHBaseHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.titan.hbase.TitanHBaseRecordReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableRecordReader;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanHBaseInputFormat
extends TitanInputFormat {
    public static final String TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_TABLENAME = "titan.hadoop.graph.input.titan.storage.tablename";
    static final byte[] EDGE_STORE_FAMILY = Bytes.toBytes((String)"edgestore");
    private final TableInputFormat tableInputFormat = new TableInputFormat();
    private TitanHBaseHadoopGraph graph;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.tableInputFormat.getSplits(jobContext);
    }

    public RecordReader<NullWritable, HadoopVertex> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new TitanHBaseRecordReader(this.graph, this.vertexQuery, (TableRecordReader)this.tableInputFormat.createRecordReader(inputSplit, taskAttemptContext));
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        this.graph = new TitanHBaseHadoopGraph(this.titanSetup);
        config.set("hbase.mapreduce.inputtable", config.get(TITAN_HADOOP_GRAPH_INPUT_TITAN_STORAGE_TABLENAME));
        config.set("hbase.zookeeper.quorum", config.get("titan.hadoop.graph.input.titan.storage.hostname"));
        if (config.get("titan.hadoop.graph.input.titan.storage.port", null) != null) {
            config.set("hbase.zookeeper.property.clientPort", config.get("titan.hadoop.graph.input.titan.storage.port"));
        }
        config.set("autotype", "none");
        Scan scanner = new Scan();
        scanner.addFamily("edgestore".getBytes());
        scanner.setFilter(this.getColumnFilter(this.vertexQuery));
        try {
            Method converter = TableMapReduceUtil.class.getDeclaredMethod("convertScanToString", Scan.class);
            converter.setAccessible(true);
            config.set("hbase.mapreduce.scan", (String)converter.invoke(null, scanner));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.tableInputFormat.setConf(config);
    }

    private Filter getColumnFilter(VertexQueryFilter inputFilter) {
        return null;
    }

    public Configuration getConf() {
        return this.tableInputFormat.getConf();
    }
}

