/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.cassandra;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.titan.cassandra.TitanCassandraHadoopGraph;
import java.io.IOException;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanCassandraRecordReader
extends RecordReader<NullWritable, HadoopVertex> {
    private ColumnFamilyRecordReader reader;
    private TitanCassandraHadoopGraph graph;
    private VertexQueryFilter vertexQuery;
    private Configuration configuration;
    private HadoopVertex vertex;

    public TitanCassandraRecordReader(TitanCassandraHadoopGraph graph, VertexQueryFilter vertexQuery, ColumnFamilyRecordReader reader) {
        this.graph = graph;
        this.vertexQuery = vertexQuery;
        this.reader = reader;
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        this.reader.initialize(inputSplit, taskAttemptContext);
        this.configuration = taskAttemptContext.getConfiguration();
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.reader.nextKeyValue()) {
            HadoopVertex temp = this.graph.readHadoopVertex(this.configuration, this.reader.getCurrentKey().duplicate(), this.reader.getCurrentValue());
            if (null == temp) continue;
            this.vertex = temp;
            this.vertexQuery.defaultFilter(this.vertex);
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    public HadoopVertex getCurrentValue() throws IOException, InterruptedException {
        return this.vertex;
    }

    public void close() throws IOException {
        this.graph.close();
        this.reader.close();
    }

    public float getProgress() {
        return this.reader.getProgress();
    }
}

