/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan.cassandra;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.titan.TitanHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.titan.input.TitanHadoopSetup;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.cassandra.db.Column;
import org.apache.hadoop.conf.Configuration;

public class TitanCassandraHadoopGraph
extends TitanHadoopGraph {
    public TitanCassandraHadoopGraph(TitanHadoopSetup setup) {
        super(setup);
    }

    public HadoopVertex readHadoopVertex(Configuration configuration, ByteBuffer key, SortedMap<ByteBuffer, Column> value) {
        return super.readHadoopVertex(configuration, (StaticBuffer)StaticArrayBuffer.of((ByteBuffer)key), new CassandraMapIterable(value));
    }

    private static class CassandraMapIterator
    implements Iterator<Entry> {
        private final Iterator<Map.Entry<ByteBuffer, Column>> iterator;

        public CassandraMapIterator(Iterator<Map.Entry<ByteBuffer, Column>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry next() {
            Map.Entry<ByteBuffer, Column> entry = this.iterator.next();
            ByteBuffer col = entry.getKey();
            ByteBuffer val = entry.getValue().value();
            return StaticArrayEntry.of((StaticBuffer)StaticArrayBuffer.of((ByteBuffer)col), (StaticBuffer)StaticArrayBuffer.of((ByteBuffer)val));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CassandraMapIterable
    implements Iterable<Entry> {
        private final SortedMap<ByteBuffer, Column> columnValues;

        public CassandraMapIterable(SortedMap<ByteBuffer, Column> columnValues) {
            Preconditions.checkNotNull(columnValues);
            this.columnValues = columnValues;
        }

        @Override
        public Iterator<Entry> iterator() {
            return new CassandraMapIterator(this.columnValues.entrySet().iterator());
        }
    }
}

