/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.titan;

import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopProperty;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.formats.titan.TitanOutputFormat;
import com.thinkaurelius.titan.hadoop.formats.titan.util.ConfigurationUtil;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TitanGraphOutputMapReduce {
    public static final Logger LOGGER = Logger.getLogger(TitanGraphOutputMapReduce.class);
    public static final String TITAN_ID = "_bId0192834";
    public static final String ID_MAP_KEY = "_iDMaPKeY";

    public static Graph generateGraph(org.apache.hadoop.conf.Configuration configuration) {
        Class format = configuration.getClass("titan.hadoop.graph.output.format", OutputFormat.class, OutputFormat.class);
        if (TitanOutputFormat.class.isAssignableFrom(format)) {
            return TitanFactory.open((Configuration)ConfigurationUtil.extractConfiguration(configuration, "titan.hadoop.graph.output.titan"));
        }
        throw new RuntimeException("The provide graph output format is not a supported TitanOutputFormat: " + format.getName());
    }

    public static org.apache.hadoop.conf.Configuration createConfiguration() {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setBoolean("mapred.map.tasks.speculative.execution", false);
        configuration.setBoolean("mapred.reduce.tasks.speculative.execution", false);
        return configuration;
    }

    public static class EdgeMap
    extends Mapper<NullWritable, HadoopVertex, NullWritable, HadoopVertex> {
        Graph graph;
        boolean trackState;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.graph = TitanGraphOutputMapReduce.generateGraph(context.getConfiguration());
            this.trackState = context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-state", false);
            LOGGER.setLevel(Level.INFO);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                for (HadoopEdge edge : value.getEdgesWithState(Direction.IN)) {
                    this.getCreateOrDeleteEdge(value, edge, context);
                }
            }
            catch (Exception e) {
                if (this.graph instanceof TransactionalGraph) {
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                }
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.graph instanceof TransactionalGraph) {
                try {
                    ((TransactionalGraph)this.graph).commit();
                    context.getCounter((Enum)Counters.SUCCESSFUL_TRANSACTIONS).increment(1L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Could not commit transaction during Reduce.cleanup(): ", (Throwable)e);
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.graph.shutdown();
        }

        public Edge getCreateOrDeleteEdge(HadoopVertex hadoopVertex, HadoopEdge hadoopEdge, Mapper.Context context) throws InterruptedException {
            TitanEdge titanEdge;
            TitanVertex titanVertex = (TitanVertex)this.graph.getVertex(hadoopVertex.getProperty(TitanGraphOutputMapReduce.TITAN_ID));
            Map idMap = (Map)hadoopVertex.getProperty(TitanGraphOutputMapReduce.ID_MAP_KEY);
            boolean isModified = hadoopEdge.isModified();
            if (this.trackState && (isModified || hadoopEdge.isDeleted())) {
                titanEdge = this.getIncident(titanVertex, hadoopEdge, idMap.get(hadoopEdge.getVertexId(Direction.OUT)));
                if (null == titanEdge) {
                    context.getCounter((Enum)Counters.NULL_EDGES_IGNORED).increment(1L);
                } else {
                    titanEdge.remove();
                    context.getCounter((Enum)Counters.EDGES_REMOVED).increment(1L);
                }
            }
            if (isModified || hadoopEdge.isNew()) {
                titanEdge = (TitanEdge)this.graph.getVertex(idMap.get(hadoopEdge.getVertexId(Direction.OUT))).addEdge(hadoopEdge.getLabel(), (Vertex)titanVertex);
                context.getCounter((Enum)Counters.EDGES_ADDED).increment(1L);
                for (HadoopProperty hadoopProperty : hadoopEdge.getProperties()) {
                    titanEdge.setProperty(hadoopProperty.getName(), hadoopProperty.getValue());
                    context.getCounter((Enum)Counters.EDGE_PROPERTIES_ADDED).increment(1L);
                }
                return titanEdge;
            }
            return null;
        }

        private TitanEdge getIncident(TitanVertex titanVertex, HadoopEdge hadoopEdge, Object otherVertexId) {
            TitanVertexQuery query = null == otherVertexId ? titanVertex.query().direction(Direction.IN).labels(new String[]{hadoopEdge.getLabel()}) : titanVertex.query().direction(Direction.IN).labels(new String[]{hadoopEdge.getLabel()}).adjacent((TitanVertex)this.graph.getVertex(otherVertexId));
            for (HadoopProperty property : hadoopEdge.getPropertiesWithState()) {
                if (!property.isLoaded()) continue;
                query.has(property.getName(), property.getValue());
            }
            for (Edge edge : query.edges()) {
                if (((TitanEdge)edge).getID() != hadoopEdge.getIdAsLong()) continue;
                return (TitanEdge)edge;
            }
            return null;
        }
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder<HadoopVertex>, NullWritable, HadoopVertex> {
        public void reduce(LongWritable key, Iterable<Holder<HadoopVertex>> values, Reducer.Context context) throws IOException, InterruptedException {
            HadoopElement hadoopVertex = null;
            HashMap idMap = new HashMap();
            for (Holder<HadoopVertex> holder : values) {
                if (holder.getTag() == 's') {
                    idMap.put(holder.get().getIdAsLong(), holder.get().getProperty(TitanGraphOutputMapReduce.TITAN_ID));
                    continue;
                }
                hadoopVertex = holder.get();
            }
            if (null != hadoopVertex) {
                hadoopVertex.setProperty(TitanGraphOutputMapReduce.ID_MAP_KEY, idMap);
                context.write((Object)NullWritable.get(), (Object)hadoopVertex);
            } else {
                LOGGER.warn((Object)("No source vertex: hadoopVertex[" + key.get() + "]"));
                context.getCounter((Enum)Counters.NULL_VERTICES_IGNORED).increment(1L);
            }
        }
    }

    public static class VertexMap
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder<HadoopVertex>> {
        Graph graph;
        boolean trackState;
        private final Holder<HadoopVertex> vertexHolder = new Holder();
        private final LongWritable longWritable = new LongWritable();

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.graph = TitanGraphOutputMapReduce.generateGraph(context.getConfiguration());
            this.trackState = context.getConfiguration().getBoolean("titan.hadoop.pipeline.track-state", false);
            LOGGER.setLevel(Level.INFO);
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            try {
                Vertex titanVertex = this.getCreateOrDeleteVertex(value, context);
                if (null != titanVertex) {
                    HadoopVertex shellVertex = new HadoopVertex(context.getConfiguration(), value.getIdAsLong());
                    shellVertex.setProperty(TitanGraphOutputMapReduce.TITAN_ID, titanVertex.getId());
                    for (Edge hadoopEdge : value.getEdges(Direction.OUT)) {
                        this.longWritable.set(((Long)hadoopEdge.getVertex(Direction.IN).getId()).longValue());
                        context.write((Object)this.longWritable, this.vertexHolder.set('s', shellVertex));
                    }
                    this.longWritable.set(value.getIdAsLong());
                    value.getPropertiesWithState().clear();
                    value.setProperty(TitanGraphOutputMapReduce.TITAN_ID, titanVertex.getId());
                    value.removeEdges(Tokens.Action.DROP, Direction.OUT, new String[0]);
                    context.write((Object)this.longWritable, this.vertexHolder.set('v', value));
                }
            }
            catch (Exception e) {
                if (this.graph instanceof TransactionalGraph) {
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                }
                throw new IOException(e.getMessage(), e);
            }
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            if (this.graph instanceof TransactionalGraph) {
                try {
                    ((TransactionalGraph)this.graph).commit();
                    context.getCounter((Enum)Counters.SUCCESSFUL_TRANSACTIONS).increment(1L);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Could not commit transaction during Map.cleanup(): ", (Throwable)e);
                    ((TransactionalGraph)this.graph).rollback();
                    context.getCounter((Enum)Counters.FAILED_TRANSACTIONS).increment(1L);
                    throw new IOException(e.getMessage(), e);
                }
            }
            this.graph.shutdown();
        }

        public Vertex getCreateOrDeleteVertex(HadoopVertex hadoopVertex, Mapper.Context context) throws InterruptedException {
            if (this.trackState && hadoopVertex.isDeleted()) {
                Vertex titanVertex = this.graph.getVertex(hadoopVertex.getId());
                if (null == titanVertex) {
                    context.getCounter((Enum)Counters.NULL_VERTICES_IGNORED).increment(1L);
                } else {
                    titanVertex.remove();
                    context.getCounter((Enum)Counters.VERTICES_REMOVED).increment(1L);
                }
                return null;
            }
            if (this.trackState && hadoopVertex.isLoaded()) {
                TitanVertex titanVertex = (TitanVertex)this.graph.getVertex(hadoopVertex.getId());
                if (null == titanVertex) {
                    context.getCounter((Enum)Counters.NULL_VERTICES_IGNORED).increment(1L);
                } else {
                    for (HadoopProperty hadoopProperty : hadoopVertex.getPropertiesWithState()) {
                        if (hadoopProperty.isNew()) {
                            titanVertex.addProperty(hadoopProperty.getName(), hadoopProperty.getValue());
                            context.getCounter((Enum)Counters.VERTEX_PROPERTIES_ADDED).increment(1L);
                            continue;
                        }
                        if (!hadoopProperty.isDeleted()) continue;
                        for (TitanProperty titanProperty : titanVertex.getProperties(hadoopProperty.getName())) {
                            if (titanProperty.getID() != hadoopProperty.getIdAsLong()) continue;
                            titanProperty.remove();
                            context.getCounter((Enum)Counters.VERTEX_PROPERTIES_REMOVED).increment(1L);
                        }
                    }
                }
                return titanVertex;
            }
            TitanVertex titanVertex = (TitanVertex)this.graph.addVertex(hadoopVertex.getId());
            context.getCounter((Enum)Counters.VERTICES_ADDED).increment(1L);
            for (HadoopProperty property : hadoopVertex.getProperties()) {
                titanVertex.addProperty(property.getName(), property.getValue());
                context.getCounter((Enum)Counters.VERTEX_PROPERTIES_ADDED).increment(1L);
            }
            return titanVertex;
        }
    }

    public static enum Counters {
        VERTICES_ADDED,
        VERTICES_REMOVED,
        VERTEX_PROPERTIES_ADDED,
        VERTEX_PROPERTIES_REMOVED,
        EDGES_ADDED,
        EDGES_REMOVED,
        EDGE_PROPERTIES_ADDED,
        EDGE_PROPERTIES_REMOVED,
        NULL_VERTEX_EDGES_IGNORED,
        NULL_VERTICES_IGNORED,
        NULL_EDGES_IGNORED,
        SUCCESSFUL_TRANSACTIONS,
        FAILED_TRANSACTIONS;

    }
}

