/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.ElementFactory;
import com.tinkerpop.blueprints.util.io.graphson.ElementPropertyConfig;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public class HadoopGraphSONUtility {
    private static final String _OUT_E = "_outE";
    private static final String _IN_E = "_inE";
    private static final String EMPTY_STRING = "";
    private static final Set<String> VERTEX_IGNORE = new HashSet<String>(Arrays.asList("_type", "_outE", "_inE"));
    private static final Set<String> EDGE_IGNORE = new HashSet<String>(Arrays.asList("_type", "_outV", "_inV"));
    private static final HadoopElementFactory elementFactory = new HadoopElementFactory();
    private static final GraphSONUtility graphson = new GraphSONUtility(GraphSONMode.COMPACT, (ElementFactory)elementFactory, ElementPropertyConfig.excludeProperties(VERTEX_IGNORE, EDGE_IGNORE));

    public static List<HadoopVertex> fromJSON(Configuration configuration, InputStream in) throws IOException {
        LinkedList<HadoopVertex> vertices = new LinkedList<HadoopVertex>();
        BufferedReader bfs = new BufferedReader(new InputStreamReader(in));
        String line = EMPTY_STRING;
        while ((line = bfs.readLine()) != null) {
            vertices.add(HadoopGraphSONUtility.fromJSON(configuration, line));
        }
        bfs.close();
        return vertices;
    }

    public static HadoopVertex fromJSON(Configuration configuration, String line) throws IOException {
        elementFactory.setConf(configuration);
        try {
            JSONObject json = new JSONObject(new JSONTokener(line));
            line = EMPTY_STRING;
            HadoopVertex vertex = (HadoopVertex)graphson.vertexFromJson(json);
            vertex.setConf(configuration);
            HadoopGraphSONUtility.fromJSONEdges(vertex, json.optJSONArray(_OUT_E), Direction.OUT);
            json.remove(_OUT_E);
            HadoopGraphSONUtility.fromJSONEdges(vertex, json.optJSONArray(_IN_E), Direction.IN);
            json.remove(_IN_E);
            return vertex;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private static void fromJSONEdges(HadoopVertex vertex, JSONArray edges, Direction direction) throws JSONException, IOException {
        if (null != edges) {
            for (int i = 0; i < edges.length(); ++i) {
                JSONObject edge = edges.optJSONObject(i);
                HadoopEdge hadoopEdge = null;
                if (direction.equals((Object)Direction.IN)) {
                    hadoopEdge = (HadoopEdge)graphson.edgeFromJson(edge, (Vertex)new HadoopVertex(vertex.getConf(), edge.optLong("_outV")), (Vertex)vertex);
                    hadoopEdge.setConf(vertex.getConf());
                } else if (direction.equals((Object)Direction.OUT)) {
                    hadoopEdge = (HadoopEdge)graphson.edgeFromJson(edge, (Vertex)vertex, (Vertex)new HadoopVertex(vertex.getConf(), edge.optLong("_inV")));
                    hadoopEdge.setConf(vertex.getConf());
                }
                if (hadoopEdge == null) continue;
                vertex.addEdge(direction, hadoopEdge);
            }
        }
    }

    public static JSONObject toJSON(Vertex vertex) throws IOException {
        try {
            JSONObject edgeObject;
            JSONObject object = GraphSONUtility.jsonFromElement((Element)vertex, HadoopGraphSONUtility.getElementPropertyKeys((Element)vertex, false), (GraphSONMode)GraphSONMode.COMPACT);
            object.put("_id", (Object)Long.valueOf(object.remove("_id").toString()));
            List edges = (List)vertex.getEdges(Direction.OUT, new String[0]);
            if (!edges.isEmpty()) {
                JSONArray outEdgesArray = new JSONArray();
                for (Edge outEdge : edges) {
                    edgeObject = GraphSONUtility.jsonFromElement((Element)outEdge, HadoopGraphSONUtility.getElementPropertyKeys((Element)outEdge, true), (GraphSONMode)GraphSONMode.COMPACT);
                    outEdgesArray.put((Object)edgeObject);
                }
                object.put(_OUT_E, (Object)outEdgesArray);
            }
            if (!(edges = (List)vertex.getEdges(Direction.IN, new String[0])).isEmpty()) {
                JSONArray inEdgesArray = new JSONArray();
                for (Edge inEdge : edges) {
                    edgeObject = GraphSONUtility.jsonFromElement((Element)inEdge, HadoopGraphSONUtility.getElementPropertyKeys((Element)inEdge, false), (GraphSONMode)GraphSONMode.COMPACT);
                    inEdgesArray.put((Object)edgeObject);
                }
                object.put(_IN_E, (Object)inEdgesArray);
            }
            return object;
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
    }

    private static Set<String> getElementPropertyKeys(Element element, boolean edgeIn) {
        HashSet<String> elementPropertyKeys = new HashSet<String>(element.getPropertyKeys());
        elementPropertyKeys.add("_id");
        if (element instanceof Edge) {
            if (edgeIn) {
                elementPropertyKeys.add("_inV");
            } else {
                elementPropertyKeys.add("_outV");
            }
            elementPropertyKeys.add("_label");
        }
        return elementPropertyKeys;
    }

    private static class HadoopElementFactory
    implements ElementFactory<HadoopVertex, HadoopEdge>,
    Configurable {
        private Configuration configuration;

        private HadoopElementFactory() {
        }

        public void setConf(Configuration configuration) {
            this.configuration = configuration;
        }

        public Configuration getConf() {
            return this.configuration;
        }

        public HadoopEdge createEdge(Object id, HadoopVertex out, HadoopVertex in, String label) {
            return new HadoopEdge(this.configuration, this.convertIdentifier(id), out.getIdAsLong(), in.getIdAsLong(), label);
        }

        public HadoopVertex createVertex(Object id) {
            return new HadoopVertex(this.configuration, this.convertIdentifier(id));
        }

        private long convertIdentifier(Object id) {
            if (id instanceof Long) {
                return (Long)id;
            }
            long identifier = -1L;
            if (id != null) {
                try {
                    identifier = Long.parseLong(id.toString());
                }
                catch (NumberFormatException e) {
                    identifier = -1L;
                }
            }
            return identifier;
        }
    }
}

