/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.graphson.HadoopGraphSONUtility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class GraphSONRecordWriter
extends RecordWriter<NullWritable, HadoopVertex> {
    private static final String UTF8 = "UTF-8";
    private static final byte[] NEWLINE;
    protected DataOutputStream out;

    public GraphSONRecordWriter(DataOutputStream out) {
        this.out = out;
    }

    public void write(NullWritable key, HadoopVertex vertex) throws IOException {
        if (null != vertex) {
            this.out.write(HadoopGraphSONUtility.toJSON(vertex).toString().getBytes(UTF8));
            this.out.write(NEWLINE);
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }

    static {
        try {
            NEWLINE = "\n".getBytes(UTF8);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Can not find UTF-8 encoding");
        }
    }
}

