/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.graphson.HadoopGraphSONUtility;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class GraphSONRecordReader
extends RecordReader<NullWritable, HadoopVertex> {
    private Configuration configuration;
    private final LineRecordReader lineRecordReader = new LineRecordReader();
    private final VertexQueryFilter vertexQuery;
    private HadoopVertex vertex = null;

    public GraphSONRecordReader(VertexQueryFilter vertexQuery) {
        this.vertexQuery = vertexQuery;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
        this.configuration = context.getConfiguration();
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.lineRecordReader.nextKeyValue()) {
            return false;
        }
        this.vertex = HadoopGraphSONUtility.fromJSON(this.configuration, this.lineRecordReader.getCurrentValue().toString());
        this.vertex.setConf(this.configuration);
        this.vertexQuery.defaultFilter(this.vertex);
        return true;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public HadoopVertex getCurrentValue() {
        return this.vertex;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

