/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.formats.edgelist.rdf.RDFBlueprintsHandler;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class RDFRecordReader
extends RecordReader<NullWritable, HadoopElement> {
    private RDFBlueprintsHandler handler;
    private LineRecordReader lineRecordReader = new LineRecordReader();
    private HadoopElement element;

    public RDFRecordReader(Configuration configuration) throws IOException {
        this.handler = new RDFBlueprintsHandler(configuration);
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
    }

    public boolean nextKeyValue() throws IOException {
        if (this.handler.hasNext()) {
            this.element = this.handler.next();
            return true;
        }
        while (this.lineRecordReader.nextKeyValue()) {
            this.handler.parse(this.lineRecordReader.getCurrentValue().toString());
            if (!this.handler.hasNext()) continue;
            this.element = this.handler.next();
            return true;
        }
        return false;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public HadoopElement getCurrentValue() {
        return this.element;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

