/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.formats.edgelist.rdf.Crc64;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;

public class RDFBlueprintsHandler
implements RDFHandler,
Iterator<HadoopElement> {
    private final Logger logger = Logger.getLogger(RDFBlueprintsHandler.class);
    private final boolean useFragments;
    private final Configuration configuration;
    private final Set<String> asProperties = new HashSet<String>();
    private final boolean literalAsProperty;
    private static final String BASE_URI = "http://thinkaurelius.com#";
    private RDFParser parser;
    private final Queue<HadoopElement> queue = new LinkedList<HadoopElement>();
    public static final Map<String, RDFFormat> formats = new HashMap<String, RDFFormat>();
    private static Map<String, Character> dataTypeToClass = new HashMap<String, Character>();
    private static final Set<String> RESERVED_FRAGMENTS;
    private static final char STRING = 's';
    private static final char INTEGER = 'i';
    private static final char FLOAT = 'f';
    private static final char DOUBLE = 'd';
    private static final char LONG = 'l';
    private static final char BOOLEAN = 'b';

    public RDFBlueprintsHandler(Configuration configuration) throws IOException {
        this.configuration = configuration;
        this.useFragments = configuration.getBoolean("titan.hadoop.graph.input.rdf.use-localname", false);
        this.literalAsProperty = configuration.getBoolean("titan.hadoop.graph.input.rdf.literal-as-property", false);
        for (String property : configuration.getStringCollection("titan.hadoop.graph.input.rdf.as-properties")) {
            this.asProperties.add(property.trim());
        }
        String formatName = configuration.get("titan.hadoop.graph.input.rdf.format");
        if (null == formatName) {
            throw new RuntimeException("RDF format is required. Use titan.hadoop.graph.input.rdf.format");
        }
        RDFFormat format = formats.get(formatName);
        if (null == format) {
            throw new RuntimeException("unknown RDF format: " + formatName);
        }
        this.parser = Rio.createParser((RDFFormat)format);
        this.parser.setRDFHandler((RDFHandler)this);
        this.parser.setDatatypeHandling(RDFParser.DatatypeHandling.IGNORE);
    }

    public void startRDF() throws RDFHandlerException {
    }

    public void endRDF() throws RDFHandlerException {
    }

    public void handleNamespace(String s, String s1) throws RDFHandlerException {
    }

    public String postProcess(Value resource) {
        if (resource instanceof URI) {
            if (this.useFragments) {
                return this.createFragment(resource);
            }
            return resource.stringValue();
        }
        return resource.stringValue();
    }

    private String createFragment(Value resource) {
        if (resource instanceof URI) {
            String frag = ((URI)resource).getLocalName();
            return RESERVED_FRAGMENTS.contains(frag) ? frag + "_" : frag;
        }
        return resource.stringValue();
    }

    private static Object castLiteral(Literal literal) {
        if (null != literal.getDatatype()) {
            Character type = dataTypeToClass.get(literal.getDatatype().stringValue());
            if (null == type) {
                return literal.getLabel();
            }
            if ('s' == type.charValue()) {
                return literal.getLabel();
            }
            if ('f' == type.charValue()) {
                return Float.valueOf(literal.getLabel());
            }
            if ('i' == type.charValue()) {
                return Integer.valueOf(literal.getLabel());
            }
            if ('d' == type.charValue()) {
                return Double.valueOf(literal.getLabel());
            }
            if ('l' == type.charValue()) {
                return Long.valueOf(literal.getLabel());
            }
            if ('b' == type.charValue()) {
                return Boolean.valueOf(literal.getLabel());
            }
            return literal.getLabel();
        }
        return literal.getLabel();
    }

    public void handleStatement(Statement s) throws RDFHandlerException {
        if (this.asProperties.contains(s.getPredicate().toString())) {
            HadoopVertex subject = new HadoopVertex(this.configuration, Crc64.digest(s.getSubject().stringValue().getBytes()));
            subject.setProperty(this.postProcess((Value)s.getPredicate()), this.postProcess(s.getObject()));
            subject.setProperty("uri", s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
        } else if (this.literalAsProperty && s.getObject() instanceof Literal) {
            HadoopVertex subject = new HadoopVertex(this.configuration, Crc64.digest(s.getSubject().stringValue().getBytes()));
            subject.setProperty(this.postProcess((Value)s.getPredicate()), RDFBlueprintsHandler.castLiteral((Literal)s.getObject()));
            subject.setProperty("uri", s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
        } else {
            long subjectId = Crc64.digest(s.getSubject().stringValue().getBytes());
            HadoopVertex subject = new HadoopVertex(this.configuration, subjectId);
            subject.setProperty("uri", s.getSubject().stringValue());
            if (this.useFragments) {
                subject.setProperty("name", this.createFragment((Value)s.getSubject()));
            }
            this.queue.add(subject);
            long objectId = Crc64.digest(s.getObject().stringValue().getBytes());
            HadoopVertex object = new HadoopVertex(this.configuration, objectId);
            object.setProperty("uri", s.getObject().stringValue());
            if (this.useFragments) {
                object.setProperty("name", this.createFragment(s.getObject()));
            }
            this.queue.add(object);
            HadoopEdge predicate = new HadoopEdge(this.configuration, -1L, subjectId, objectId, this.postProcess((Value)s.getPredicate()));
            predicate.setProperty("uri", s.getPredicate().stringValue());
            if (null != s.getContext()) {
                predicate.setProperty("context", s.getContext().stringValue());
            }
            this.queue.add(predicate);
        }
    }

    public void handleComment(String s) throws RDFHandlerException {
    }

    public boolean parse(String string) throws IOException {
        if (null == string) {
            return false;
        }
        try {
            this.parser.parse((Reader)new StringReader(string), BASE_URI);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public HadoopElement next() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.remove();
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static {
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#string", Character.valueOf('s'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#int", Character.valueOf('i'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#integer", Character.valueOf('i'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#float", Character.valueOf('f'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#double", Character.valueOf('d'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#long", Character.valueOf('l'));
        dataTypeToClass.put("http://www.w3.org/2001/XMLSchema#boolean", Character.valueOf('b'));
        RESERVED_FRAGMENTS = new HashSet<String>();
        RESERVED_FRAGMENTS.add("label");
        RESERVED_FRAGMENTS.add("id");
        formats.put("rdf-xml", RDFFormat.RDFXML);
        formats.put("n-triples", RDFFormat.NTRIPLES);
        formats.put("turtle", RDFFormat.TURTLE);
        formats.put("n3", RDFFormat.N3);
        formats.put("trix", RDFFormat.TRIX);
        formats.put("trig", RDFFormat.TRIG);
    }
}

