/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;

public class EdgeCopyMapReduce {
    public static final String TITAN_HADOOP_GRAPH_INPUT_EDGE_COPY_DIRECTION = "titan.hadoop.graph.input.edge-copy.direction";

    public static Configuration createConfiguration(Direction direction) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setEnum(TITAN_HADOOP_GRAPH_INPUT_EDGE_COPY_DIRECTION, (Enum)direction);
        return configuration;
    }

    public static class Reduce
    extends Reducer<LongWritable, Holder<HadoopVertex>, NullWritable, HadoopVertex> {
        private Direction direction = Direction.OUT;

        public void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.direction = (Direction)context.getConfiguration().getEnum(EdgeCopyMapReduce.TITAN_HADOOP_GRAPH_INPUT_EDGE_COPY_DIRECTION, (Enum)Direction.OUT);
            if (this.direction.equals((Object)Direction.BOTH)) {
                throw new InterruptedException(ExceptionFactory.bothIsNotSupported().getMessage());
            }
        }

        public void reduce(LongWritable key, Iterable<Holder<HadoopVertex>> values, Reducer.Context context) throws IOException, InterruptedException {
            long edgesAggregated = 0L;
            HadoopVertex vertex = new HadoopVertex(context.getConfiguration(), key.get());
            for (Holder<HadoopVertex> holder : values) {
                if (holder.getTag() == 's') {
                    edgesAggregated += (long)((List)holder.get().getEdges(this.direction.opposite())).size();
                    vertex.addEdges(this.direction.opposite(), holder.get());
                    continue;
                }
                vertex.addAll(holder.get());
            }
            context.write((Object)NullWritable.get(), (Object)vertex);
            context.getCounter((Enum)Counters.EDGES_ADDED).increment(edgesAggregated);
        }
    }

    public static class Map
    extends Mapper<NullWritable, HadoopVertex, LongWritable, Holder<HadoopVertex>> {
        private final Holder<HadoopVertex> vertexHolder = new Holder();
        private final LongWritable longWritable = new LongWritable();
        private Direction direction = Direction.OUT;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.direction = (Direction)context.getConfiguration().getEnum(EdgeCopyMapReduce.TITAN_HADOOP_GRAPH_INPUT_EDGE_COPY_DIRECTION, (Enum)Direction.OUT);
            if (this.direction.equals((Object)Direction.BOTH)) {
                throw new InterruptedException(ExceptionFactory.bothIsNotSupported().getMessage());
            }
        }

        public void map(NullWritable key, HadoopVertex value, Mapper.Context context) throws IOException, InterruptedException {
            long edgesInverted = 0L;
            for (Edge edge : value.getEdges(this.direction)) {
                long id = (Long)edge.getVertex(this.direction.opposite()).getId();
                this.longWritable.set(id);
                HadoopVertex shellVertex = new HadoopVertex(context.getConfiguration(), id);
                shellVertex.addEdge(this.direction.opposite(), (HadoopEdge)edge);
                context.write((Object)this.longWritable, this.vertexHolder.set('s', shellVertex));
                ++edgesInverted;
            }
            this.longWritable.set(value.getIdAsLong());
            context.write((Object)this.longWritable, this.vertexHolder.set('r', value));
            context.getCounter((Enum)Counters.EDGES_COPIED).increment(edgesInverted);
        }
    }

    public static enum Counters {
        EDGES_COPIED,
        EDGES_ADDED;

    }
}

