/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.GenericWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class WeightedWritable<T extends WritableComparable>
extends GenericWritable
implements WritableComparable<WeightedWritable<T>> {
    protected long weight;
    private static Class[] CLASSES;

    protected Class<T>[] getTypes() {
        return CLASSES;
    }

    public WeightedWritable() {
    }

    public WeightedWritable(DataInput in) throws IOException {
        this();
        this.readFields(in);
    }

    public WeightedWritable(long weight, T element) {
        this();
        this.set((Writable)element);
        this.weight = weight;
    }

    public int hashCode() {
        return super.get().hashCode();
    }

    public long getWeight() {
        return this.weight;
    }

    public T get() {
        return (T)((WritableComparable)super.get());
    }

    public WeightedWritable<T> set(long weight, T writable) {
        this.set((Writable)writable);
        this.weight = weight;
        return this;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.weight);
        super.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.weight = in.readLong();
        super.readFields(in);
    }

    public boolean equals(Object object) {
        return object.getClass().equals(WeightedWritable.class) && ((WeightedWritable)((Object)object)).get().equals(this.get());
    }

    public int compareTo(WeightedWritable<T> writable) {
        return writable.get().compareTo(this.get());
    }

    public String toString() {
        return "[" + this.weight + "," + super.get() + "]";
    }

    static {
        WritableComparator.define(WeightedWritable.class, (WritableComparator)new Comparator());
        CLASSES = new Class[]{HadoopVertex.class, HadoopEdge.class, Text.class};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(WeightedWritable.class);
        }

        public int compare(WritableComparable a, WritableComparable b) {
            if (a instanceof WeightedWritable && b instanceof WeightedWritable) {
                return ((WeightedWritable)a).get().compareTo(((WeightedWritable)b).get());
            }
            return super.compare(a, b);
        }
    }
}

