/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.hadoop.ElementState;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopProperty;
import com.thinkaurelius.titan.hadoop.HadoopSerializer;
import com.thinkaurelius.titan.hadoop.HadoopType;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.VertexQuery;
import com.tinkerpop.blueprints.util.DefaultVertexQuery;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;

public class HadoopVertex
extends HadoopPathElement
implements Vertex {
    protected ListMultimap<HadoopType, HadoopEdge> outEdges = ArrayListMultimap.create();
    protected ListMultimap<HadoopType, HadoopEdge> inEdges = ArrayListMultimap.create();

    public HadoopVertex() {
        super(EmptyConfiguration.immutable(), -1L);
    }

    public HadoopVertex(Configuration configuration) {
        super(configuration, -1L);
    }

    public HadoopVertex(Configuration configuration, long id) {
        super(configuration, id);
    }

    public HadoopVertex(Configuration configuration, DataInput in) throws IOException {
        super(configuration, -1L);
        this.readFields(in);
    }

    public void addAll(HadoopVertex vertex) {
        this.id = vertex.getIdAsLong();
        this.properties = vertex.properties;
        this.getPaths(vertex, false);
        this.state = vertex.getState();
        this.addEdges(Direction.BOTH, vertex);
    }

    @Override
    void updateSchema(HadoopSerializer.Schema schema) {
        super.updateSchema(schema);
        for (Direction dir : Direction.proper) {
            for (HadoopEdge edge : this.getAdjacency(dir).values()) {
                edge.updateSchema(schema);
            }
        }
    }

    @Override
    public HadoopProperty addProperty(HadoopProperty property) {
        return super.addProperty(property);
    }

    public HadoopProperty addProperty(String key, Object value) {
        HadoopType type = HadoopType.DEFAULT_MANAGER.get(key);
        return this.addProperty(new HadoopProperty(type, value));
    }

    public <T> Iterable<T> getProperties(String key) {
        HadoopType type = HadoopType.DEFAULT_MANAGER.get(key);
        if (type.isImplicit()) {
            return Arrays.asList(this.getImplicitProperty(type));
        }
        return Iterables.transform((Iterable)Iterables.filter((Iterable)this.properties.get((Object)type), (Predicate)FILTER_DELETED_PROPERTIES), (Function)new Function<HadoopProperty, T>(){

            @Nullable
            public T apply(@Nullable HadoopProperty hadoopProperty) {
                return hadoopProperty.getValue();
            }
        });
    }

    public Iterable<HadoopProperty> getProperties(HadoopType type) {
        Preconditions.checkArgument((!type.isImplicit() ? 1 : 0) != 0);
        return Iterables.filter((Iterable)this.properties.get((Object)type), (Predicate)FILTER_DELETED_PROPERTIES);
    }

    public VertexQuery query() {
        return new DefaultVertexQuery((Vertex)this);
    }

    private ListMultimap<HadoopType, HadoopEdge> getAdjacency(Direction direction) {
        switch (direction) {
            case IN: {
                return this.inEdges;
            }
            case OUT: {
                return this.outEdges;
            }
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    static boolean containsUndeletedEdge(ListMultimap<HadoopType, HadoopEdge> edgeList, HadoopType type) {
        return !Iterables.isEmpty((Iterable)Iterables.filter((Iterable)edgeList.get((Object)type), (Predicate)FILTER_DELETED_EDGES));
    }

    public Set<HadoopType> getEdgeLabels(final Direction direction) {
        if (direction == Direction.BOTH) {
            return Sets.union(this.getEdgeLabels(Direction.IN), this.getEdgeLabels(Direction.OUT));
        }
        return Sets.filter((Set)this.getAdjacency(direction).keySet(), (Predicate)new Predicate<HadoopType>(){

            public boolean apply(HadoopType hadoopType) {
                return !hadoopType.isHidden() && HadoopVertex.containsUndeletedEdge((ListMultimap<HadoopType, HadoopEdge>)HadoopVertex.this.getAdjacency(direction), hadoopType);
            }
        });
    }

    public Iterable<Vertex> getVertices(final Direction direction, final String ... labels) {
        return new Iterable<Vertex>(){

            @Override
            public Iterator<Vertex> iterator() {
                return new Iterator<Vertex>(){
                    final Iterator<Edge> edges;
                    final Direction opposite;
                    {
                        this.edges = HadoopVertex.this.getEdges(direction, labels).iterator();
                        this.opposite = direction.opposite();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.edges.hasNext();
                    }

                    @Override
                    public Vertex next() {
                        return this.edges.next().getVertex(this.opposite);
                    }
                };
            }
        };
    }

    public Iterable<HadoopEdge> getEdgesWithState(Direction direction) {
        return this.getAdjacency(direction).values();
    }

    public Iterable<Edge> getEdges(Direction direction, String ... labels) {
        if (labels == null) {
            labels = new String[]{};
        }
        HadoopType[] types = new HadoopType[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            types[i] = HadoopType.DEFAULT_MANAGER.get(labels[i]);
        }
        return this.getEdges(direction, types);
    }

    public Iterable<Edge> getEdges(Direction direction) {
        return this.getEdges(direction, new HadoopType[0]);
    }

    public Iterable<Edge> getEdges(Direction direction, HadoopType ... labels) {
        ArrayList<List<HadoopEdge>> edgeLists = new ArrayList<List<HadoopEdge>>();
        for (Direction dir : Direction.proper) {
            if (direction != Direction.BOTH && direction != dir) continue;
            ListMultimap<HadoopType, HadoopEdge> adj = this.getAdjacency(dir);
            if (null == labels || labels.length == 0) {
                for (HadoopType type : adj.keySet()) {
                    if (type.isHidden()) continue;
                    edgeLists.add(adj.get((Object)type));
                }
                continue;
            }
            for (HadoopType label : labels) {
                List temp = adj.get((Object)label);
                edgeLists.add(temp);
            }
        }
        return new EdgeList(edgeLists);
    }

    private void addEdges(Direction direction, HadoopType label, List<HadoopEdge> edges) {
        this.getAdjacency(direction).putAll((Object)label, edges);
    }

    public void addEdges(Direction direction, HadoopVertex vertex) {
        for (Direction dir : Direction.proper) {
            if (direction != dir && !direction.equals((Object)Direction.BOTH)) continue;
            for (HadoopType label : vertex.getEdgeLabels(dir)) {
                this.addEdges(dir, label, (List)vertex.getEdges(dir, label));
            }
        }
    }

    public Edge addEdge(String label, Vertex inVertex) {
        return this.addEdge(Direction.OUT, new HadoopEdge(this.configuration, this.getIdAsLong(), ((HadoopVertex)inVertex).getIdAsLong(), label));
    }

    public Edge addEdge(Direction direction, String label, long otherVertexId) {
        if (direction == Direction.OUT) {
            return this.addEdge(Direction.OUT, new HadoopEdge(this.configuration, this.id, otherVertexId, label));
        }
        if (direction == Direction.IN) {
            return this.addEdge(Direction.IN, new HadoopEdge(this.configuration, otherVertexId, this.id, label));
        }
        throw ExceptionFactory.bothIsNotSupported();
    }

    public HadoopEdge addEdge(Direction direction, HadoopEdge edge) {
        edge.setConf(this.getConf());
        this.getAdjacency(direction).put((Object)edge.getType(), (Object)edge);
        return edge;
    }

    public void removeEdgesToFrom(Set<Long> ids) {
        for (Direction dir : Direction.proper) {
            Iterator edges = this.getAdjacency(dir).values().iterator();
            while (edges.hasNext()) {
                HadoopEdge edge = (HadoopEdge)edges.next();
                if (!ids.contains(edge.getVertexId(dir.opposite()))) continue;
                if (edge.isNew()) {
                    edges.remove();
                }
                edge.setState(ElementState.DELETED);
            }
        }
    }

    private void removeAllEdges(Direction dir, Iterable<HadoopType> types) {
        types = Lists.newArrayList(types);
        ListMultimap<HadoopType, HadoopEdge> adj = this.getAdjacency(dir);
        for (HadoopType type : types) {
            Iterator iter = adj.get((Object)type).iterator();
            while (iter.hasNext()) {
                HadoopEdge edge = (HadoopEdge)iter.next();
                if (edge.isNew()) {
                    iter.remove();
                }
                edge.setState(ElementState.DELETED);
            }
        }
    }

    public void removeEdges(Tokens.Action action, Direction direction, String ... stringLabels) {
        HashSet labels = Sets.newHashSet();
        for (String string : stringLabels) {
            labels.add(HadoopType.DEFAULT_MANAGER.get(string));
        }
        if (action.equals((Object)Tokens.Action.KEEP)) {
            for (String string : Direction.proper) {
                if (direction != Direction.BOTH && direction != string) continue;
                ListMultimap<HadoopType, HadoopEdge> adj = this.getAdjacency((Direction)string);
                if (labels.size() > 0) {
                    HashSet removal = Sets.newHashSet((Iterable)adj.keySet());
                    removal.removeAll(labels);
                    this.removeAllEdges((Direction)string, removal);
                    continue;
                }
                if (direction != string) continue;
                this.removeAllEdges(string.opposite(), this.getAdjacency(string.opposite()).keySet());
            }
        } else {
            assert (action.equals((Object)Tokens.Action.DROP));
            for (String string : Direction.proper) {
                if (direction != Direction.BOTH && direction != string) continue;
                if (labels.isEmpty()) {
                    this.removeAllEdges((Direction)string, this.getAdjacency((Direction)string).keySet());
                    continue;
                }
                this.removeAllEdges((Direction)string, labels);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        new HadoopSerializer(this.getConf()).writeVertex(this, out);
    }

    public void readFields(DataInput in) throws IOException {
        new HadoopSerializer(this.getConf()).readVertex(this, in);
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public static class MicroVertex
    extends HadoopPathElement.MicroElement {
        private static final String V1 = "v[";
        private static final String V2 = "]";

        public MicroVertex(long id) {
            super(id);
        }

        public String toString() {
            return V1 + this.id + V2;
        }
    }

    private class EdgeList
    extends AbstractList<HadoopEdge> {
        final List<List<HadoopEdge>> edges;
        int fullsize;
        int size;

        public EdgeList(List<List<HadoopEdge>> edgeLists) {
            this.edges = edgeLists;
            this.fullsize = 0;
            this.size = 0;
            for (List<HadoopEdge> temp : this.edges) {
                this.fullsize += temp.size();
                for (HadoopEdge e : temp) {
                    if (e.isDeleted()) continue;
                    ++this.size;
                }
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public HadoopEdge get(int index) {
            throw new UnsupportedOperationException();
        }

        public HadoopEdge getDirect(int index) {
            int lowIndex = 0;
            int highIndex = 0;
            for (List<HadoopEdge> temp : this.edges) {
                if (index < (highIndex += temp.size())) {
                    return temp.get(index - lowIndex);
                }
                lowIndex += temp.size();
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }

        private void removeList(int index) {
            int lowIndex = 0;
            int highIndex = 0;
            for (List<HadoopEdge> temp : this.edges) {
                if (index < (highIndex += temp.size())) {
                    temp.remove(index - lowIndex);
                    return;
                }
                lowIndex += temp.size();
            }
            throw new ArrayIndexOutOfBoundsException(index);
        }

        @Override
        public Iterator<HadoopEdge> iterator() {
            return new Iterator<HadoopEdge>(){
                private int current = -1;
                private int next = this.findNext(this.current);

                private int findNext(int current) {
                    int next;
                    for (next = current + 1; next < EdgeList.this.fullsize && EdgeList.this.getDirect(next).isDeleted(); ++next) {
                    }
                    return next;
                }

                @Override
                public boolean hasNext() {
                    return this.next < EdgeList.this.fullsize;
                }

                @Override
                public HadoopEdge next() {
                    this.current = this.next;
                    this.next = this.findNext(this.current);
                    return EdgeList.this.getDirect(this.current);
                }

                @Override
                public void remove() {
                    HadoopEdge toDelete = EdgeList.this.getDirect(this.current);
                    if (toDelete.isNew()) {
                        EdgeList.this.removeList(this.current);
                        --this.next;
                        --EdgeList.this.fullsize;
                    }
                    toDelete.setState(ElementState.DELETED);
                    this.current = -1;
                    --EdgeList.this.size;
                }
            };
        }
    }
}

