/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.thinkaurelius.titan.diskstorage.ReadBuffer;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.util.ReadArrayBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.database.serialize.StandardSerializer;
import com.thinkaurelius.titan.hadoop.ElementState;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopElement;
import com.thinkaurelius.titan.hadoop.HadoopPathElement;
import com.thinkaurelius.titan.hadoop.HadoopProperty;
import com.thinkaurelius.titan.hadoop.HadoopType;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.util.datastructures.IterablesUtil;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class HadoopSerializer {
    private final Serializer serializer;
    private final HadoopType.Manager types;
    private final boolean trackState;
    private final boolean trackPaths;
    private final Configuration configuration;

    public HadoopSerializer(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.serializer = new StandardSerializer(true);
        this.types = HadoopType.DEFAULT_MANAGER;
        this.configuration = configuration;
        this.trackState = configuration.getBoolean("titan.hadoop.pipeline.track-state", false);
        this.trackPaths = configuration.getBoolean("titan.hadoop.pipeline.track-paths", false);
    }

    public void writeVertex(HadoopVertex vertex, DataOutput out) throws IOException {
        WritableUtils.writeVLong((DataOutput)out, (long)vertex.id);
        Schema schema = new Schema();
        vertex.updateSchema(schema);
        schema.writeSchema(out);
        this.writePathElement(vertex, schema, out);
        this.writeEdges(vertex.inEdges, out, Direction.OUT, schema);
        this.writeEdges(vertex.outEdges, out, Direction.IN, schema);
    }

    public void readVertex(HadoopVertex vertex, DataInput in) throws IOException {
        WritableUtils.readVLong((DataInput)in);
        Schema schema = this.readSchema(in);
        this.readPathElement(vertex, schema, in);
        vertex.inEdges = this.readEdges(in, Direction.OUT, vertex.id, schema);
        vertex.outEdges = this.readEdges(in, Direction.IN, vertex.id, schema);
    }

    public void writeEdge(HadoopEdge edge, DataOutput out) throws IOException {
        this.writePathElement(edge, out);
        WritableUtils.writeVLong((DataOutput)out, (long)edge.inVertex);
        WritableUtils.writeVLong((DataOutput)out, (long)edge.outVertex);
        this.writeHadoopType(edge.getType(), out);
    }

    public void readEdge(HadoopEdge edge, DataInput in) throws IOException {
        this.readPathElement(edge, in);
        edge.inVertex = WritableUtils.readVLong((DataInput)in);
        edge.outVertex = WritableUtils.readVLong((DataInput)in);
        edge.setLabel(this.readHadoopType(in));
    }

    private void readPathElement(HadoopPathElement element, DataInput in) throws IOException {
        this.readPathElement(element, null, in);
    }

    private void writePathElement(HadoopPathElement element, DataOutput out) throws IOException {
        this.writePathElement(element, null, out);
    }

    private void readPathElement(HadoopPathElement element, Schema schema, DataInput in) throws IOException {
        this.readElement(element, schema, in);
        if (this.trackPaths) {
            element.paths = this.readElementPaths(in);
            element.microVersion = element instanceof HadoopVertex ? new HadoopVertex.MicroVertex(element.id) : new HadoopEdge.MicroEdge(element.id);
            element.trackPaths = true;
        } else {
            element.pathCounter = WritableUtils.readVLong((DataInput)in);
            element.trackPaths = false;
        }
    }

    private void writePathElement(HadoopPathElement element, Schema schema, DataOutput out) throws IOException {
        this.writeElement(element, schema, out);
        if (this.trackPaths) {
            this.writeElementPaths(element.paths, out);
        } else {
            WritableUtils.writeVLong((DataOutput)out, (long)element.pathCounter);
        }
    }

    private void readElement(HadoopElement element, Schema schema, DataInput in) throws IOException {
        element.id = WritableUtils.readVLong((DataInput)in);
        if (this.trackState) {
            element.setState(ElementState.valueOf(in.readByte()));
        }
        element.properties = this.readProperties(schema, in);
    }

    private void writeElement(HadoopElement element, Schema schema, DataOutput out) throws IOException {
        Preconditions.checkArgument((this.trackState || !element.isDeleted() ? 1 : 0) != 0);
        WritableUtils.writeVLong((DataOutput)out, (long)element.id);
        if (this.trackState) {
            out.writeByte(element.getState().getByteValue());
        }
        this.writeProperties(element.properties, schema, out);
    }

    private <T extends HadoopElement> Iterable<T> filterDeleted(Iterable<T> elements) {
        if (this.trackState) {
            return elements;
        }
        return Iterables.filter(elements, (Predicate)new Predicate<T>(){

            public boolean apply(@Nullable T element) {
                return !((HadoopElement)element).isDeleted();
            }
        });
    }

    private void writeProperties(Multimap<HadoopType, HadoopProperty> properties, Schema schema, DataOutput out) throws IOException {
        Iterable subset = this.filterDeleted(properties.values());
        int count = IterablesUtil.size(subset);
        WritableUtils.writeVInt((DataOutput)out, (int)count);
        if (count > 0) {
            for (HadoopProperty property : subset) {
                if (schema == null) {
                    this.writeHadoopType(property.getType(), out);
                } else {
                    WritableUtils.writeVLong((DataOutput)out, (long)schema.getTypeId(property.getType()));
                }
                com.thinkaurelius.titan.graphdb.database.serialize.DataOutput o = this.serializer.getDataOutput(40);
                o.writeClassAndObject(property.getValue());
                StaticBuffer buffer = o.getStaticBuffer();
                WritableUtils.writeVInt((DataOutput)out, (int)buffer.length());
                out.write((byte[])buffer.as(StaticBuffer.ARRAY_FACTORY));
                this.writeElement(property, schema, out);
            }
        }
    }

    private Multimap<HadoopType, HadoopProperty> readProperties(Schema schema, DataInput in) throws IOException {
        int count = WritableUtils.readVInt((DataInput)in);
        if (count == 0) {
            return HadoopElement.NO_PROPERTIES;
        }
        HashMultimap properties = HashMultimap.create();
        for (int i = 0; i < count; ++i) {
            HadoopType type = schema == null ? this.readHadoopType(in) : schema.getType(WritableUtils.readVLong((DataInput)in));
            int byteLength = WritableUtils.readVInt((DataInput)in);
            byte[] bytes = new byte[byteLength];
            in.readFully(bytes);
            ReadArrayBuffer buffer = new ReadArrayBuffer(bytes);
            Object value = this.serializer.readClassAndObject((ReadBuffer)buffer);
            HadoopProperty property = new HadoopProperty(type, value);
            this.readElement(property, schema, in);
            properties.put((Object)type, (Object)property);
        }
        return properties;
    }

    private ListMultimap<HadoopType, HadoopEdge> readEdges(DataInput in, Direction idToRead, long otherId, Schema schema) throws IOException {
        ArrayListMultimap edges = ArrayListMultimap.create();
        int edgeTypes = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < edgeTypes; ++i) {
            HadoopType type = schema.getType(WritableUtils.readVLong((DataInput)in));
            int size = WritableUtils.readVInt((DataInput)in);
            for (int j = 0; j < size; ++j) {
                HadoopEdge edge = new HadoopEdge(this.configuration);
                this.readPathElement(edge, schema, in);
                edge.setLabel(type);
                long vertexId = WritableUtils.readVLong((DataInput)in);
                switch (idToRead) {
                    case IN: {
                        edge.inVertex = vertexId;
                        edge.outVertex = otherId;
                        break;
                    }
                    case OUT: {
                        edge.outVertex = vertexId;
                        edge.inVertex = otherId;
                        break;
                    }
                    default: {
                        throw ExceptionFactory.bothIsNotSupported();
                    }
                }
                edges.put((Object)type, (Object)edge);
            }
        }
        return edges;
    }

    private void writeEdges(ListMultimap<HadoopType, HadoopEdge> edges, DataOutput out, Direction idToWrite, Schema schema) throws IOException {
        HashMap counts = Maps.newHashMap();
        int typeCount = 0;
        for (HadoopType type : edges.keySet()) {
            int count = IterablesUtil.size(this.filterDeleted(edges.get((Object)type)));
            counts.put(type, count);
            if (count <= 0) continue;
            ++typeCount;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)typeCount);
        for (HadoopType type : edges.keySet()) {
            if ((Integer)counts.get(type) == 0) continue;
            Iterable subset = this.filterDeleted(edges.get((Object)type));
            WritableUtils.writeVLong((DataOutput)out, (long)schema.getTypeId(type));
            WritableUtils.writeVInt((DataOutput)out, (int)((Integer)counts.get(type)));
            for (HadoopEdge edge : subset) {
                this.writePathElement(edge, schema, out);
                WritableUtils.writeVLong((DataOutput)out, (long)edge.getVertexId(idToWrite));
            }
        }
    }

    private void writeElementPaths(List<List<HadoopPathElement.MicroElement>> paths, DataOutput out) throws IOException {
        if (null == paths) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            WritableUtils.writeVInt((DataOutput)out, (int)paths.size());
            for (List<HadoopPathElement.MicroElement> path : paths) {
                WritableUtils.writeVInt((DataOutput)out, (int)path.size());
                for (HadoopPathElement.MicroElement element : path) {
                    if (element instanceof HadoopVertex.MicroVertex) {
                        out.writeChar(118);
                    } else {
                        out.writeChar(101);
                    }
                    WritableUtils.writeVLong((DataOutput)out, (long)element.getId());
                }
            }
        }
    }

    private List<List<HadoopPathElement.MicroElement>> readElementPaths(DataInput in) throws IOException {
        int pathsSize = WritableUtils.readVInt((DataInput)in);
        if (pathsSize == 0) {
            return new ArrayList<List<HadoopPathElement.MicroElement>>();
        }
        ArrayList<List<HadoopPathElement.MicroElement>> paths = new ArrayList<List<HadoopPathElement.MicroElement>>(pathsSize);
        for (int i = 0; i < pathsSize; ++i) {
            int pathSize = WritableUtils.readVInt((DataInput)in);
            ArrayList<HadoopPathElement.MicroElement> path = new ArrayList<HadoopPathElement.MicroElement>(pathSize);
            for (int j = 0; j < pathSize; ++j) {
                char type = in.readChar();
                if (type == 'v') {
                    path.add(new HadoopVertex.MicroVertex(WritableUtils.readVLong((DataInput)in)));
                    continue;
                }
                path.add(new HadoopEdge.MicroEdge(WritableUtils.readVLong((DataInput)in)));
            }
            paths.add(path);
        }
        return paths;
    }

    private void writeHadoopType(HadoopType type, DataOutput out) throws IOException {
        out.writeUTF(type.getName());
    }

    private HadoopType readHadoopType(DataInput in) throws IOException {
        return this.types.get(in.readUTF());
    }

    private Schema readSchema(DataInput in) throws IOException {
        int size = WritableUtils.readVInt((DataInput)in);
        Schema schema = new Schema(size);
        for (int i = 0; i < size; ++i) {
            schema.add(this.readHadoopType(in), WritableUtils.readVLong((DataInput)in));
        }
        return schema;
    }

    public void writeVertex(Vertex vertex, ElementIdHandler elementIdHandler, DataOutput out) throws IOException {
        Schema schema = new Schema();
        Multimap<HadoopType, HadoopProperty> properties = this.getProperties((Element)vertex);
        for (HadoopType type : properties.keySet()) {
            schema.add(type);
        }
        for (Edge edge : vertex.getEdges(Direction.BOTH, new String[0])) {
            schema.add(edge.getLabel());
            for (String key : edge.getPropertyKeys()) {
                schema.add(key);
            }
        }
        WritableUtils.writeVLong((DataOutput)out, (long)elementIdHandler.convertIdentifier((Element)vertex));
        schema.writeSchema(out);
        WritableUtils.writeVLong((DataOutput)out, (long)elementIdHandler.convertIdentifier((Element)vertex));
        if (this.trackState) {
            out.writeByte(ElementState.NEW.getByteValue());
        }
        this.writeProperties(properties, schema, out);
        out.writeBoolean(false);
        WritableUtils.writeVLong((DataOutput)out, (long)0L);
        this.writeEdges(vertex, Direction.IN, elementIdHandler, schema, out);
        this.writeEdges(vertex, Direction.OUT, elementIdHandler, schema, out);
    }

    private Multimap<HadoopType, HadoopProperty> getProperties(Element element) {
        HashMultimap properties = HashMultimap.create();
        for (String key : element.getPropertyKeys()) {
            HadoopType type = this.types.get(key);
            properties.put((Object)type, (Object)new HadoopProperty(type, element.getProperty(key)));
        }
        return properties;
    }

    private void writeEdges(Vertex vertex, Direction direction, ElementIdHandler elementIdHandler, Schema schema, DataOutput out) throws IOException {
        HashMultiset labelCount = HashMultiset.create();
        for (Edge edge : vertex.getEdges(direction, new String[0])) {
            labelCount.add((Object)edge.getLabel());
        }
        WritableUtils.writeVInt((DataOutput)out, (int)labelCount.elementSet().size());
        for (String label : labelCount.elementSet()) {
            HadoopType type = this.types.get(label);
            WritableUtils.writeVLong((DataOutput)out, (long)schema.getTypeId(type));
            WritableUtils.writeVInt((DataOutput)out, (int)labelCount.count((Object)label));
            for (Edge edge : vertex.getEdges(direction, new String[]{label})) {
                WritableUtils.writeVLong((DataOutput)out, (long)elementIdHandler.convertIdentifier((Element)edge));
                if (this.trackState) {
                    out.writeByte(ElementState.NEW.getByteValue());
                }
                this.writeProperties(this.getProperties((Element)edge), schema, out);
                out.writeBoolean(false);
                WritableUtils.writeVLong((DataOutput)out, (long)0L);
                WritableUtils.writeVLong((DataOutput)out, (long)elementIdHandler.convertIdentifier((Element)edge.getVertex(direction.opposite())));
            }
        }
    }

    static {
        WritableComparator.define(HadoopPathElement.class, (WritableComparator)new Comparator());
    }

    public static interface ElementIdHandler {
        public long convertIdentifier(Element var1);
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(HadoopPathElement.class);
        }

        public int compare(byte[] element1, int start1, int length1, byte[] element2, int start2, int length2) {
            try {
                return Long.valueOf(Comparator.readVLong((byte[])element1, (int)start1)).compareTo(Comparator.readVLong((byte[])element2, (int)start2));
            }
            catch (IOException e) {
                return -1;
            }
        }

        public int compare(WritableComparable a, WritableComparable b) {
            if (a instanceof HadoopElement && b instanceof HadoopElement) {
                return Long.valueOf(((HadoopElement)a).getIdAsLong()).compareTo(((HadoopElement)b).getIdAsLong());
            }
            return super.compare(a, b);
        }
    }

    class Schema {
        private final BiMap<HadoopType, Long> localTypes;
        private long count = 1L;

        private Schema() {
            this(8);
        }

        private Schema(int size) {
            this.localTypes = HashBiMap.create((int)size);
        }

        void add(String type) {
            this.add(HadoopSerializer.this.types.get(type));
        }

        void add(HadoopType type) {
            if (!this.localTypes.containsKey((Object)type)) {
                this.localTypes.put((Object)type, (Object)this.count++);
            }
        }

        void addAll(Iterable<HadoopType> types) {
            for (HadoopType type : types) {
                this.add(type);
            }
        }

        long getTypeId(HadoopType type) {
            Long id = (Long)this.localTypes.get((Object)type);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)("Type is not part of the schema: " + type));
            return id;
        }

        HadoopType getType(long id) {
            HadoopType type = (HadoopType)this.localTypes.inverse().get((Object)id);
            Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)("Type is not part of the schema: " + id));
            return type;
        }

        private void add(HadoopType type, long index) {
            Preconditions.checkArgument((!this.localTypes.containsValue((Object)index) ? 1 : 0) != 0);
            this.localTypes.put((Object)type, (Object)index);
            this.count = index + 1L;
        }

        private void writeSchema(DataOutput out) throws IOException {
            WritableUtils.writeVInt((DataOutput)out, (int)this.localTypes.size());
            for (Map.Entry entry : this.localTypes.entrySet()) {
                HadoopSerializer.this.writeHadoopType((HadoopType)entry.getKey(), out);
                WritableUtils.writeVLong((DataOutput)out, (long)((Long)entry.getValue()));
            }
        }
    }
}

