/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.hadoop.HadoopGraph;
import com.thinkaurelius.titan.hadoop.HadoopVertex;
import com.thinkaurelius.titan.hadoop.Holder;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.formats.EdgeCopyMapReduce;
import com.thinkaurelius.titan.hadoop.formats.MapReduceFormat;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.HadoopCompiler;
import com.thinkaurelius.titan.hadoop.mapreduce.IdentityMap;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.BackFilterMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.CyclicPathFilterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.DuplicateFilterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.FilterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.IntervalFilterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.filter.PropertyFilterMap;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.CommitEdgesMap;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.CommitVerticesMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.GroupCountMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.LinkMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.ScriptMap;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.SideEffectMap;
import com.thinkaurelius.titan.hadoop.mapreduce.sideeffect.ValueGroupCountMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.EdgesMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.EdgesVerticesMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.OrderMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.PathMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.PropertyMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.PropertyMapMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.TransformMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.VertexMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.VerticesEdgesMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.VerticesMap;
import com.thinkaurelius.titan.hadoop.mapreduce.transform.VerticesVerticesMapReduce;
import com.thinkaurelius.titan.hadoop.mapreduce.util.CountMapReduce;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.Tokens;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.structures.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;

public class HadoopPipeline {
    protected static final ScriptEngine engine = new GroovyScriptEngineImpl();
    public static final String PIPELINE_IS_LOCKED = "No more steps are possible as pipeline is locked";
    protected final HadoopCompiler compiler;
    protected final HadoopGraph graph;
    protected final State state;
    protected final List<String> stringRepresentation = new ArrayList<String>();

    private Compare convert(Tokens.T compare) {
        if (compare.equals((Object)Tokens.T.eq)) {
            return Compare.EQUAL;
        }
        if (compare.equals((Object)Tokens.T.neq)) {
            return Compare.NOT_EQUAL;
        }
        if (compare.equals((Object)Tokens.T.gt)) {
            return Compare.GREATER_THAN;
        }
        if (compare.equals((Object)Tokens.T.gte)) {
            return Compare.GREATER_THAN_EQUAL;
        }
        if (compare.equals((Object)Tokens.T.lt)) {
            return Compare.LESS_THAN;
        }
        return Compare.LESS_THAN_EQUAL;
    }

    public HadoopPipeline(HadoopGraph graph) {
        this.graph = graph;
        this.compiler = HadoopCompatLoader.getCompilerFor(graph);
        this.state = new State();
        if (MapReduceFormat.class.isAssignableFrom(this.graph.getGraphInputFormat())) {
            try {
                ((MapReduceFormat)this.graph.getGraphInputFormat().getConstructor(new Class[0]).newInstance(new Object[0])).addMapReduceJobs(this.compiler);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (null != this.graph.getConf().get("titan.hadoop.graph.input.edge-copy.direction")) {
            this.compiler.addMapReduce(EdgeCopyMapReduce.Map.class, null, EdgeCopyMapReduce.Reduce.class, null, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, EdgeCopyMapReduce.createConfiguration((Direction)this.graph.getConf().getEnum("titan.hadoop.graph.input.edge-copy.direction", (Enum)Direction.OUT)));
        }
    }

    public HadoopPipeline _() {
        this.state.assertNotLocked();
        this.compiler.addMap(IdentityMap.Map.class, NullWritable.class, HadoopVertex.class, IdentityMap.createConfiguration());
        this.makeMapReduceString(IdentityMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline transform(String closure) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(TransformMap.Map.class, NullWritable.class, HadoopVertex.class, TransformMap.createConfiguration(this.state.getElementType(), this.validateClosure(closure)));
        this.state.lock();
        this.makeMapReduceString(TransformMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline V() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.set(Vertex.class);
        this.compiler.addMap(VerticesMap.Map.class, NullWritable.class, HadoopVertex.class, VerticesMap.createConfiguration(this.state.incrStep() != 0));
        this.makeMapReduceString(VerticesMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline E() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.set(Edge.class);
        this.compiler.addMap(EdgesMap.Map.class, NullWritable.class, HadoopVertex.class, EdgesMap.createConfiguration(this.state.incrStep() != 0));
        this.makeMapReduceString(EdgesMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline v(long ... ids) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.set(Vertex.class);
        this.state.incrStep();
        this.compiler.addMap(VertexMap.Map.class, NullWritable.class, HadoopVertex.class, VertexMap.createConfiguration(ids));
        this.makeMapReduceString(VertexMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline out(String ... labels) {
        return this.inOutBoth(Direction.OUT, labels);
    }

    public HadoopPipeline in(String ... labels) {
        return this.inOutBoth(Direction.IN, labels);
    }

    public HadoopPipeline both(String ... labels) {
        return this.inOutBoth(Direction.BOTH, labels);
    }

    private HadoopPipeline inOutBoth(Direction direction, String ... labels) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.assertAtVertex();
        this.state.incrStep();
        this.compiler.addMapReduce(VerticesVerticesMapReduce.Map.class, null, VerticesVerticesMapReduce.Reduce.class, null, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, VerticesVerticesMapReduce.createConfiguration(direction, labels));
        this.state.set(Vertex.class);
        this.makeMapReduceString(VerticesVerticesMapReduce.class, direction.name(), Arrays.asList(labels));
        return this;
    }

    public HadoopPipeline outE(String ... labels) {
        return this.inOutBothE(Direction.OUT, labels);
    }

    public HadoopPipeline inE(String ... labels) {
        return this.inOutBothE(Direction.IN, labels);
    }

    public HadoopPipeline bothE(String ... labels) {
        return this.inOutBothE(Direction.BOTH, labels);
    }

    private HadoopPipeline inOutBothE(Direction direction, String ... labels) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.assertAtVertex();
        this.state.incrStep();
        this.compiler.addMapReduce(VerticesEdgesMapReduce.Map.class, null, VerticesEdgesMapReduce.Reduce.class, null, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, VerticesEdgesMapReduce.createConfiguration(direction, labels));
        this.state.set(Edge.class);
        this.makeMapReduceString(VerticesEdgesMapReduce.class, direction.name(), Arrays.asList(labels));
        return this;
    }

    public HadoopPipeline outV() {
        return this.inOutBothV(Direction.OUT);
    }

    public HadoopPipeline inV() {
        return this.inOutBothV(Direction.IN);
    }

    public HadoopPipeline bothV() {
        return this.inOutBothV(Direction.BOTH);
    }

    private HadoopPipeline inOutBothV(Direction direction) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.assertAtEdge();
        this.state.incrStep();
        this.compiler.addMap(EdgesVerticesMap.Map.class, NullWritable.class, HadoopVertex.class, EdgesVerticesMap.createConfiguration(direction));
        this.state.set(Vertex.class);
        this.makeMapReduceString(EdgesVerticesMap.class, direction.name());
        return this;
    }

    public HadoopPipeline property(String key, Class type) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.setProperty(key, type);
        return this;
    }

    public HadoopPipeline property(String key) {
        return this.property(key, String.class);
    }

    public HadoopPipeline map() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(PropertyMapMap.Map.class, LongWritable.class, Text.class, PropertyMapMap.createConfiguration(this.state.getElementType()));
        this.makeMapReduceString(PropertyMap.class, new Object[0]);
        this.state.lock();
        return this;
    }

    public HadoopPipeline label() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.assertAtEdge();
        this.property("label", String.class);
        return this;
    }

    public HadoopPipeline path() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(PathMap.Map.class, NullWritable.class, Text.class, PathMap.createConfiguration(this.state.getElementType()));
        this.state.lock();
        this.makeMapReduceString(PathMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline order(TransformPipe.Order order, String elementKey) {
        this.state.assertNotLocked();
        Pair<String, Class<? extends WritableComparable>> pair = this.state.popProperty();
        if (null == pair) {
            throw new IllegalArgumentException("There is no specified property to order on");
        }
        this.compiler.addMapReduce(OrderMapReduce.Map.class, null, OrderMapReduce.Reduce.class, OrderMapReduce.createComparator(order, (Class)pair.getB()), (Class)pair.getB(), Text.class, Text.class, (Class)pair.getB(), OrderMapReduce.createConfiguration(this.state.getElementType(), (String)pair.getA(), (Class)pair.getB(), elementKey));
        this.makeMapReduceString(OrderMapReduce.class, order.name(), elementKey);
        this.state.lock();
        return this;
    }

    public HadoopPipeline order(TransformPipe.Order order) {
        return this.order(order, "id");
    }

    public HadoopPipeline order(Tokens.T order, String elementKey) {
        return this.order(Tokens.mapOrder((Tokens.T)order), elementKey);
    }

    public HadoopPipeline order(Tokens.T order) {
        return this.order(Tokens.mapOrder((Tokens.T)order));
    }

    public HadoopPipeline filter(String closure) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(FilterMap.Map.class, NullWritable.class, HadoopVertex.class, FilterMap.createConfiguration(this.state.getElementType(), this.validateClosure(closure)));
        this.makeMapReduceString(FilterMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline has(String key, Tokens.T compare, Object ... values) {
        return this.has(key, this.convert(compare), values);
    }

    public HadoopPipeline hasNot(String key, Tokens.T compare, Object ... values) {
        return this.hasNot(key, this.convert(compare), values);
    }

    public HadoopPipeline has(String key, Compare compare, Object ... values) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(PropertyFilterMap.Map.class, NullWritable.class, HadoopVertex.class, PropertyFilterMap.createConfiguration(this.state.getElementType(), key, compare, values));
        this.makeMapReduceString(PropertyFilterMap.class, compare.name(), Arrays.asList(values));
        return this;
    }

    public HadoopPipeline hasNot(String key, Compare compare, Object ... values) {
        return this.has(key, compare.opposite(), values);
    }

    public HadoopPipeline has(String key, Object ... values) {
        return values.length == 0 ? this.has(key, Compare.NOT_EQUAL, new Object[]{null}) : this.has(key, Compare.EQUAL, values);
    }

    public HadoopPipeline hasNot(String key, Object ... values) {
        return values.length == 0 ? this.has(key, Compare.EQUAL, new Object[]{null}) : this.has(key, Compare.NOT_EQUAL, values);
    }

    public HadoopPipeline interval(String key, Object startValue, Object endValue) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(IntervalFilterMap.Map.class, NullWritable.class, HadoopVertex.class, IntervalFilterMap.createConfiguration(this.state.getElementType(), key, startValue, endValue));
        this.makeMapReduceString(IntervalFilterMap.class, key, startValue, endValue);
        return this;
    }

    public HadoopPipeline dedup() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(DuplicateFilterMap.Map.class, NullWritable.class, HadoopVertex.class, DuplicateFilterMap.createConfiguration(this.state.getElementType()));
        this.makeMapReduceString(DuplicateFilterMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline back(String step) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMapReduce(BackFilterMapReduce.Map.class, BackFilterMapReduce.Combiner.class, BackFilterMapReduce.Reduce.class, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, BackFilterMapReduce.createConfiguration(this.state.getElementType(), this.state.getStep(step)));
        this.makeMapReduceString(BackFilterMapReduce.class, step);
        return this;
    }

    public HadoopPipeline simplePath() {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(CyclicPathFilterMap.Map.class, NullWritable.class, HadoopVertex.class, CyclicPathFilterMap.createConfiguration(this.state.getElementType()));
        this.makeMapReduceString(CyclicPathFilterMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline sideEffect(String closure) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMap(SideEffectMap.Map.class, NullWritable.class, HadoopVertex.class, SideEffectMap.createConfiguration(this.state.getElementType(), this.validateClosure(closure)));
        this.makeMapReduceString(SideEffectMap.class, new Object[0]);
        return this;
    }

    public HadoopPipeline as(String name) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.addStep(name);
        String string = "As(" + name + "," + this.stringRepresentation.get(this.state.getStep(name)) + ")";
        this.stringRepresentation.set(this.state.getStep(name), string);
        return this;
    }

    public HadoopPipeline linkIn(String label, String step, String mergeWeightKey) {
        return this.link(Direction.IN, label, step, mergeWeightKey);
    }

    public HadoopPipeline linkIn(String label, String step) {
        return this.link(Direction.IN, label, step, null);
    }

    public HadoopPipeline linkOut(String label, String step, String mergeWeightKey) {
        return this.link(Direction.OUT, label, step, mergeWeightKey);
    }

    public HadoopPipeline linkOut(String label, String step) {
        return this.link(Direction.OUT, label, step, null);
    }

    private HadoopPipeline link(Direction direction, String label, String step, String mergeWeightKey) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.compiler.addMapReduce(LinkMapReduce.Map.class, LinkMapReduce.Combiner.class, LinkMapReduce.Reduce.class, null, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, LinkMapReduce.createConfiguration(direction, label, this.state.getStep(step), mergeWeightKey));
        if (null != mergeWeightKey) {
            this.makeMapReduceString(LinkMapReduce.class, direction.name(), label, step, mergeWeightKey);
        } else {
            this.makeMapReduceString(LinkMapReduce.class, direction.name(), label, step);
        }
        return this;
    }

    public HadoopPipeline groupCount() {
        this.state.assertNotLocked();
        Pair<String, Class<? extends WritableComparable>> pair = this.state.popProperty();
        if (null == pair) {
            return this.groupCount(null, null);
        }
        this.compiler.addMapReduce(ValueGroupCountMapReduce.Map.class, ValueGroupCountMapReduce.Combiner.class, ValueGroupCountMapReduce.Reduce.class, (Class)pair.getB(), LongWritable.class, (Class)pair.getB(), LongWritable.class, ValueGroupCountMapReduce.createConfiguration(this.state.getElementType(), (String)pair.getA(), (Class)pair.getB()));
        this.makeMapReduceString(ValueGroupCountMapReduce.class, pair.getA());
        return this;
    }

    public HadoopPipeline groupCount(String keyClosure) {
        return this.groupCount(keyClosure, null);
    }

    public HadoopPipeline groupCount(String keyClosure, String valueClosure) {
        this.state.assertNotLocked();
        this.compiler.addMapReduce(GroupCountMapReduce.Map.class, GroupCountMapReduce.Combiner.class, GroupCountMapReduce.Reduce.class, Text.class, LongWritable.class, Text.class, LongWritable.class, GroupCountMapReduce.createConfiguration(this.state.getElementType(), this.validateClosure(keyClosure), this.validateClosure(valueClosure)));
        this.makeMapReduceString(GroupCountMapReduce.class, new Object[0]);
        return this;
    }

    private HadoopPipeline commit(Tokens.Action action) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        if (this.state.atVertex()) {
            this.compiler.addMapReduce(CommitVerticesMapReduce.Map.class, CommitVerticesMapReduce.Combiner.class, CommitVerticesMapReduce.Reduce.class, null, LongWritable.class, Holder.class, NullWritable.class, HadoopVertex.class, CommitVerticesMapReduce.createConfiguration(action));
            this.makeMapReduceString(CommitVerticesMapReduce.class, action.name());
        } else {
            this.compiler.addMap(CommitEdgesMap.Map.class, NullWritable.class, HadoopVertex.class, CommitEdgesMap.createConfiguration(action));
            this.makeMapReduceString(CommitEdgesMap.class, action.name());
        }
        return this;
    }

    public HadoopPipeline drop() {
        return this.commit(Tokens.Action.DROP);
    }

    public HadoopPipeline keep() {
        return this.commit(Tokens.Action.KEEP);
    }

    public HadoopPipeline script(String scriptUri, String ... args) {
        this.state.assertNotLocked();
        this.state.assertNoProperty();
        this.state.assertAtVertex();
        this.compiler.addMap(ScriptMap.Map.class, NullWritable.class, HadoopVertex.class, ScriptMap.createConfiguration(scriptUri, args));
        this.makeMapReduceString(CommitEdgesMap.class, scriptUri);
        return this;
    }

    public HadoopPipeline count() {
        this.state.assertNotLocked();
        this.compiler.addMapReduce(CountMapReduce.Map.class, CountMapReduce.Combiner.class, CountMapReduce.Reduce.class, NullWritable.class, LongWritable.class, NullWritable.class, LongWritable.class, CountMapReduce.createConfiguration(this.state.getElementType()));
        this.makeMapReduceString(CountMapReduce.class, new Object[0]);
        this.state.lock();
        return this;
    }

    public String toString() {
        return this.stringRepresentation.toString();
    }

    private HadoopPipeline done() {
        Pair<String, Class<? extends WritableComparable>> pair;
        if (!this.state.isLocked() && null != (pair = this.state.popProperty())) {
            this.compiler.addMap(PropertyMap.Map.class, LongWritable.class, (Class)pair.getB(), PropertyMap.createConfiguration(this.state.getElementType(), (String)pair.getA(), (Class)pair.getB()));
            this.makeMapReduceString(PropertyMap.class, pair.getA());
            this.state.lock();
        }
        return this;
    }

    public void submit() throws Exception {
        this.submit("", false);
    }

    public void submit(String script, Boolean showHeader) throws Exception {
        this.done();
        if (MapReduceFormat.class.isAssignableFrom(this.graph.getGraphOutputFormat())) {
            this.state.assertNotLocked();
            ((MapReduceFormat)this.graph.getGraphOutputFormat().getConstructor(new Class[0]).newInstance(new Object[0])).addMapReduceJobs(this.compiler);
        }
        this.compiler.completeSequence();
        ToolRunner.run((Tool)this.compiler, (String[])new String[]{script, showHeader.toString()});
    }

    public HadoopGraph getGraph() {
        return this.graph;
    }

    public HadoopCompiler getCompiler() {
        return this.compiler;
    }

    private String validateClosure(String closure) {
        if (closure == null) {
            return null;
        }
        try {
            engine.eval(closure);
            return closure;
        }
        catch (ScriptException e) {
            closure = closure.trim();
            closure = closure.replaceFirst("\\{", "{it->");
            try {
                engine.eval(closure);
                return closure;
            }
            catch (ScriptException scriptException) {
                throw new IllegalArgumentException("The provided closure does not compile: " + e.getMessage(), e);
            }
        }
    }

    private void makeMapReduceString(Class klass, Object ... arguments) {
        String result = klass.getSimpleName();
        if (arguments.length > 0) {
            result = result + "(";
            for (Object arg : arguments) {
                result = result + arg + ",";
            }
            result = result.substring(0, result.length() - 1) + ")";
        }
        this.stringRepresentation.add(result);
    }

    private Class<? extends WritableComparable> convertJavaToHadoop(Class klass) {
        if (klass.equals(String.class)) {
            return Text.class;
        }
        if (klass.equals(Integer.class)) {
            return IntWritable.class;
        }
        if (klass.equals(Double.class)) {
            return DoubleWritable.class;
        }
        if (klass.equals(Long.class)) {
            return LongWritable.class;
        }
        if (klass.equals(Float.class)) {
            return FloatWritable.class;
        }
        if (klass.equals(Boolean.class)) {
            return BooleanWritable.class;
        }
        throw new IllegalArgumentException("The provided class is not supported: " + klass.getSimpleName());
    }

    protected class State {
        private Class<? extends Element> elementType;
        private String propertyKey;
        private Class<? extends WritableComparable> propertyType;
        private int step = -1;
        private boolean locked = false;
        private Map<String, Integer> namedSteps = new HashMap<String, Integer>();

        protected State() {
        }

        public State set(Class<? extends Element> elementType) {
            if (!elementType.equals(Vertex.class) && !elementType.equals(Edge.class)) {
                throw new IllegalArgumentException("The element class type must be either Vertex or Edge");
            }
            this.elementType = elementType;
            return this;
        }

        public Class<? extends Element> getElementType() {
            return this.elementType;
        }

        public boolean atVertex() {
            if (null == this.elementType) {
                throw new IllegalStateException("No element type can be inferred: start vertices (or edges) set must be defined");
            }
            return this.elementType.equals(Vertex.class);
        }

        public State setProperty(String key, Class type) {
            this.propertyKey = key;
            this.propertyType = HadoopPipeline.this.convertJavaToHadoop(type);
            return this;
        }

        public Pair<String, Class<? extends WritableComparable>> popProperty() {
            if (null == this.propertyKey) {
                return null;
            }
            Pair pair = new Pair((Object)this.propertyKey, this.propertyType);
            this.propertyKey = null;
            this.propertyType = null;
            return pair;
        }

        public int incrStep() {
            return ++this.step;
        }

        public int getStep() {
            return this.step;
        }

        public void assertNotLocked() {
            if (this.locked) {
                throw new IllegalStateException(HadoopPipeline.PIPELINE_IS_LOCKED);
            }
        }

        public void assertNoProperty() {
            if (this.propertyKey != null) {
                throw new IllegalStateException("This step can not follow a property reference");
            }
        }

        public void assertAtVertex() {
            if (!this.atVertex()) {
                throw new IllegalStateException("This step can not follow an edge-based step");
            }
        }

        public void assertAtEdge() {
            if (this.atVertex()) {
                throw new IllegalStateException("This step can not follow a vertex-based step");
            }
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void addStep(String name) {
            if (this.step == -1) {
                throw new IllegalArgumentException("There is no previous step to name");
            }
            this.namedSteps.put(name, this.step);
        }

        public int getStep(String name) {
            Integer i = this.namedSteps.get(name);
            if (null == i) {
                throw new IllegalArgumentException("There is no step identified by: " + name);
            }
            return i;
        }
    }
}

