/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.hadoop.ElementState;
import com.thinkaurelius.titan.hadoop.HadoopEdge;
import com.thinkaurelius.titan.hadoop.HadoopProperty;
import com.thinkaurelius.titan.hadoop.HadoopSerializer;
import com.thinkaurelius.titan.hadoop.HadoopType;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class HadoopElement
implements Element,
Comparable<HadoopElement> {
    static final Multimap<HadoopType, HadoopProperty> NO_PROPERTIES = ImmutableListMultimap.of();
    protected static final Predicate<HadoopProperty> FILTER_DELETED_PROPERTIES = new Predicate<HadoopProperty>(){

        public boolean apply(@Nullable HadoopProperty p) {
            return !p.isDeleted();
        }
    };
    protected static final Predicate<HadoopEdge> FILTER_DELETED_EDGES = new Predicate<HadoopEdge>(){

        public boolean apply(@Nullable HadoopEdge e) {
            return !e.isDeleted();
        }
    };
    protected long id;
    protected Multimap<HadoopType, HadoopProperty> properties = NO_PROPERTIES;
    protected ElementState state = ElementState.NEW;

    public HadoopElement(long id) {
        this.id = id;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public Object getId() {
        return this.id;
    }

    public long getIdAsLong() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    void updateSchema(HadoopSerializer.Schema schema) {
        schema.addAll(this.properties.keySet());
    }

    public void setState(ElementState state) {
        Preconditions.checkNotNull((Object)((Object)state));
        this.state = state;
    }

    public ElementState getState() {
        return this.state;
    }

    public boolean isNew() {
        return this.state == ElementState.NEW;
    }

    public boolean isDeleted() {
        return this.state == ElementState.DELETED;
    }

    public boolean isLoaded() {
        return this.state == ElementState.LOADED;
    }

    public boolean isModified() {
        for (HadoopProperty property : this.getPropertiesWithState()) {
            if (!property.isDeleted() && !property.isNew()) continue;
            return true;
        }
        return false;
    }

    protected void initializeProperties() {
        if (this.properties == NO_PROPERTIES) {
            this.properties = HashMultimap.create();
        }
    }

    protected <T> T getImplicitProperty(HadoopType type) {
        assert (type.isImplicit());
        return null;
    }

    protected HadoopProperty addProperty(final HadoopProperty property) {
        Preconditions.checkNotNull((Object)property);
        ElementHelper.validateProperty((Element)this, (String)property.getType().getName(), (Object)property.getValue());
        this.initializeProperties();
        if (this.properties.containsEntry((Object)property.getType(), (Object)property)) {
            HadoopProperty old = (HadoopProperty)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)this.properties.get((Object)property.getType()), (Predicate)new Predicate<HadoopProperty>(){

                public boolean apply(@Nullable HadoopProperty hadoopProperty) {
                    return hadoopProperty.equals(property);
                }
            }));
            if (property.isNew() && old.isDeleted()) {
                old.setState(ElementState.LOADED);
            } else if (property.isLoaded() && old.isNew()) {
                old.setState(ElementState.LOADED);
            }
            return old;
        }
        this.properties.put((Object)property.getType(), (Object)property);
        return property;
    }

    public void setProperty(String key, Object value) {
        HadoopType type = HadoopType.DEFAULT_MANAGER.get(key);
        Iterator props = this.properties.get((Object)type).iterator();
        while (props.hasNext()) {
            HadoopProperty p = (HadoopProperty)props.next();
            if (p.isNew()) {
                props.remove();
                continue;
            }
            p.setState(ElementState.DELETED);
        }
        this.addProperty(new HadoopProperty(type, value));
    }

    public <T> T removeProperty(String key) {
        if (this.properties.isEmpty()) {
            return null;
        }
        HadoopType type = HadoopType.DEFAULT_MANAGER.get(key);
        ArrayList removed = Lists.newArrayList();
        Iterator props = this.properties.get((Object)type).iterator();
        while (props.hasNext()) {
            HadoopProperty p = (HadoopProperty)props.next();
            if (!p.isDeleted()) {
                removed.add(p);
            }
            if (p.isNew()) {
                props.remove();
                continue;
            }
            p.setState(ElementState.DELETED);
        }
        if (removed.isEmpty()) {
            return null;
        }
        if (removed.size() == 1) {
            return (T)((HadoopProperty)removed.iterator().next()).getValue();
        }
        return (T)removed;
    }

    public <T> T getProperty(String key) {
        HadoopType type = HadoopType.DEFAULT_MANAGER.get(key);
        if (type.isImplicit()) {
            return this.getImplicitProperty(type);
        }
        Object result = null;
        for (HadoopProperty p : this.properties.get((Object)type)) {
            if (p.isDeleted()) continue;
            if (result != null) {
                throw new IllegalStateException("Use getProperties(String) method for multi-valued properties");
            }
            result = p.getValue();
        }
        return (T)result;
    }

    public Set<String> getPropertyKeys() {
        HashSet result = Sets.newHashSet();
        for (HadoopProperty p : this.properties.values()) {
            if (p.isDeleted() || p.getType().isHidden()) continue;
            result.add(p.getType().getName());
        }
        return result;
    }

    public Collection<HadoopProperty> getProperties() {
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.properties.values(), (Predicate)new Predicate<HadoopProperty>(){

            public boolean apply(@Nullable HadoopProperty property) {
                return !property.getType().isHidden() && !property.isDeleted();
            }
        }));
        return result;
    }

    public void addAllProperties(Iterable<HadoopProperty> properties) {
        for (HadoopProperty p : properties) {
            this.addProperty(p);
        }
    }

    public Collection<HadoopProperty> getPropertiesWithState() {
        return this.properties.values();
    }

    public boolean equals(Object other) {
        return this.getClass().equals(other.getClass()) && this.id == ((HadoopElement)other).getIdAsLong();
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    @Override
    public int compareTo(HadoopElement other) {
        return new Long(this.id).compareTo((Long)other.getId());
    }
}

