/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.source;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.SaxSink;
import org.semarglproject.source.AbstractSource;
import org.semarglproject.source.CharSource;
import org.semarglproject.source.SaxSource;

public abstract class BaseStreamProcessor {
    protected abstract void startStream() throws ParseException;

    protected abstract void endStream() throws ParseException;

    protected abstract void processInternal(Reader var1, String var2, String var3) throws ParseException;

    protected abstract void processInternal(InputStream var1, String var2, String var3) throws ParseException;

    public abstract boolean setProperty(String var1, Object var2);

    public final void process(File file) throws ParseException {
        String baseUri = "file://" + file.getAbsolutePath();
        this.process(file, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(File file, String baseUri) throws ParseException {
        FileReader reader;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new ParseException(e);
        }
        try {
            this.process(reader, null, baseUri);
        }
        finally {
            BaseStreamProcessor.closeQuietly(reader);
        }
    }

    public final void process(String uri) throws ParseException {
        this.process(uri, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(String uri, String baseUri) throws ParseException {
        URL url;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new ParseException(e);
        }
        try {
            URLConnection urlConnection = url.openConnection();
            String mimeType = urlConnection.getContentType();
            InputStream inputStream = urlConnection.getInputStream();
            try {
                this.process(inputStream, mimeType, baseUri);
            }
            finally {
                BaseStreamProcessor.closeQuietly(inputStream);
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void process(InputStream inputStream, String baseUri) throws ParseException {
        this.process(inputStream, null, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(InputStream inputStream, String mimeType, String baseUri) throws ParseException {
        this.startStream();
        try {
            this.processInternal(inputStream, mimeType, baseUri);
        }
        finally {
            this.endStream();
        }
    }

    public void process(Reader reader, String baseUri) throws ParseException {
        this.process(reader, null, baseUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Reader reader, String mimeType, String baseUri) throws ParseException {
        this.startStream();
        try {
            this.processInternal(reader, mimeType, baseUri);
        }
        finally {
            this.endStream();
        }
    }

    protected static AbstractSource createSourceForSink(DataSink sink) {
        if (sink instanceof CharSink) {
            return new CharSource((CharSink)sink);
        }
        if (sink instanceof SaxSink) {
            return new SaxSource((SaxSink)sink);
        }
        return null;
    }

    static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

