/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.sesame.core.sink;

import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.TripleSink;

public class SesameSink
implements TripleSink {
    public static final String RDF_HANDLER_PROPERTY = "http://semarglproject.org/sesame/properties/rdf-handler";
    public static final String VALUE_FACTORY_PROPERTY = "http://semarglproject.org/sesame/properties/value-factory";
    protected RDFHandler handler;
    protected ValueFactory valueFactory = ValueFactoryImpl.getInstance();

    protected SesameSink(RDFHandler handler) {
        this.handler = handler;
    }

    public static TripleSink connect(RDFHandler handler) {
        return new SesameSink(handler);
    }

    private Resource convertNonLiteral(String arg) {
        if (arg.startsWith("_:")) {
            return this.valueFactory.createBNode(arg.substring(2));
        }
        return this.valueFactory.createURI(arg);
    }

    public final void addNonLiteral(String subj, String pred, String obj) {
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), (Value)this.convertNonLiteral(obj));
    }

    public final void addPlainLiteral(String subj, String pred, String content, String lang) {
        if (lang == null) {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), (Value)this.valueFactory.createLiteral(content));
        } else {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), (Value)this.valueFactory.createLiteral(content, lang));
        }
    }

    public final void addTypedLiteral(String subj, String pred, String content, String type) {
        Literal literal = this.valueFactory.createLiteral(content, this.valueFactory.createURI(type));
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createURI(pred), (Value)literal);
    }

    protected void addTriple(Resource subject, URI predicate, Value object) {
        try {
            this.handler.handleStatement(this.valueFactory.createStatement(subject, predicate, object));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void startStream() throws ParseException {
        try {
            this.handler.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void endStream() throws ParseException {
        try {
            this.handler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public boolean setProperty(String key, Object value) {
        if (RDF_HANDLER_PROPERTY.equals(key) && value instanceof RDFHandler) {
            this.handler = (RDFHandler)value;
        } else if (VALUE_FACTORY_PROPERTY.equals(key) && value instanceof ValueFactory) {
            this.valueFactory = (ValueFactory)value;
        } else {
            return false;
        }
        return true;
    }

    public void setBaseUri(String baseUri) {
    }
}

