/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event;

import com.tinkerpop.blueprints.util.wrappers.event.EventGraph;
import com.tinkerpop.blueprints.util.wrappers.event.listener.Event;
import java.util.ArrayDeque;
import java.util.Deque;

public class EventTrigger {
    private final ThreadLocal<Deque<Event>> eventQueue = new ThreadLocal<Deque<Event>>(){

        @Override
        protected Deque<Event> initialValue() {
            return new ArrayDeque<Event>();
        }
    };
    private final boolean enqueEvents;
    private final EventGraph graph;

    public EventTrigger(EventGraph graph, boolean enqueEvents) {
        this.enqueEvents = enqueEvents;
        this.graph = graph;
    }

    public void addEvent(Event evt) {
        this.eventQueue.get().add(evt);
        if (!this.enqueEvents) {
            this.fireEventQueue();
            this.resetEventQueue();
        }
    }

    public void resetEventQueue() {
        this.eventQueue.set(new ArrayDeque());
    }

    public void fireEventQueue() {
        Deque<Event> deque = this.eventQueue.get();
        Event event = deque.pollFirst();
        while (event != null) {
            event.fireEvent(this.graph.getListenerIterator());
            event = deque.pollFirst();
        }
    }
}

