/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import net.fortytwo.linkeddata.Dereferencer;
import net.fortytwo.linkeddata.dereferencers.FileURIDereferencer;
import net.fortytwo.ripple.RippleException;
import org.restlet.representation.Representation;
import org.restlet.representation.StreamRepresentation;

public class JarURIDereferencer
implements Dereferencer {
    @Override
    public Representation dereference(String uri) throws RippleException {
        return new JarRepresentation(uri);
    }

    public String toString() {
        return "JAR URI dereferencer";
    }

    private class JarRepresentation
    extends StreamRepresentation {
        private InputStream inputStream;

        public JarRepresentation(String uri) throws RippleException {
            super(FileURIDereferencer.findMediaType(uri));
            try {
                JarURLConnection jc = (JarURLConnection)new URL(uri).openConnection();
                this.inputStream = jc.getInputStream();
            }
            catch (IOException e) {
                throw new RippleException((Throwable)e);
            }
        }

        public ReadableByteChannel getChannel() throws IOException {
            return null;
        }

        public InputStream getStream() throws IOException {
            return this.inputStream;
        }

        public void write(OutputStream outputStream) throws IOException {
        }

        public void write(WritableByteChannel writableByteChannel) throws IOException {
        }
    }
}

