/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata.dereferencers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import net.fortytwo.flow.rdf.HTTPUtils;
import net.fortytwo.ripple.RippleException;
import net.fortytwo.ripple.StringUtils;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.restlet.data.MediaType;
import org.restlet.representation.StreamRepresentation;

public class HTTPRepresentation
extends StreamRepresentation {
    private final InputStream inputStream;
    private final HttpMethod method;
    private final long idleTime;

    public HTTPRepresentation(String uri, String acceptHeader) throws RippleException {
        super(null);
        InputStream is;
        this.method = HTTPUtils.createGetMethod((String)uri);
        HTTPUtils.setAcceptHeader((HttpMethod)this.method, (String)acceptHeader);
        this.idleTime = HTTPUtils.throttleHttpRequest((HttpMethod)this.method);
        HttpClient client = HTTPUtils.createClient();
        try {
            client.executeMethod(this.method);
        }
        catch (ConnectTimeoutException e) {
        }
        catch (IOException e) {
            throw new RippleException((Throwable)e);
        }
        int code = this.method.getStatusCode();
        if (2 != code / 100) {
            throw new ErrorResponseException("" + code + " response for resource <" + StringUtils.escapeURIString((String)uri) + ">");
        }
        try {
            is = this.method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            throw new RippleException((Throwable)e);
        }
        this.inputStream = new HttpRepresentationInputStream(is);
        Header h = this.method.getResponseHeader("Content-Type");
        if (null == h) {
            throw new InvalidResponseException("no content-type header served for resource <" + StringUtils.escapeURIString((String)uri) + ">");
        }
        String mtStr = h.getValue().split(";")[0];
        if (null == mtStr || 0 == mtStr.length()) {
            throw new InvalidResponseException("no media type found for resource <" + StringUtils.escapeURIString((String)uri) + ">");
        }
        MediaType mt = new MediaType(mtStr);
        this.setMediaType(mt);
    }

    public ReadableByteChannel getChannel() throws IOException {
        return null;
    }

    public InputStream getStream() throws IOException {
        return this.inputStream;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public void write(OutputStream outputStream) throws IOException {
    }

    public void write(WritableByteChannel writableByteChannel) throws IOException {
    }

    public class InvalidResponseException
    extends RippleException {
        public InvalidResponseException(String message) {
            super(message);
        }

        public HttpMethod getMethod() {
            return HTTPRepresentation.this.method;
        }
    }

    public class ErrorResponseException
    extends RippleException {
        public ErrorResponseException(String message) {
            super(message);
        }

        public HttpMethod getMethod() {
            return HTTPRepresentation.this.method;
        }
    }

    private class HttpRepresentationInputStream
    extends InputStream {
        private InputStream innerInputStream;

        public HttpRepresentationInputStream(InputStream is) {
            this.innerInputStream = is;
        }

        @Override
        public int read() throws IOException {
            return this.innerInputStream.read();
        }

        @Override
        public void close() throws IOException {
            HTTPRepresentation.this.method.releaseConnection();
            this.innerInputStream.close();
        }

        @Override
        public int available() throws IOException {
            return this.innerInputStream.available();
        }
    }
}

