/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.linkeddata;

import info.aduna.iteration.CloseableIteration;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fortytwo.linkeddata.CacheEntry;
import net.fortytwo.linkeddata.LinkedDataCache;
import net.fortytwo.ripple.RippleException;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;

public class CachingMetadata {
    private final InMemoryCache memos;
    private final ValueFactory valueFactory;
    private final CacheEntry miss;

    public CachingMetadata(int capacity, ValueFactory valueFactory) throws RippleException {
        this.memos = new InMemoryCache(capacity);
        this.valueFactory = valueFactory;
        this.miss = new CacheEntry();
    }

    public CacheEntry getMemo(String graphUri, SailConnection sc) throws RippleException {
        CacheEntry memo = (CacheEntry)this.memos.get(graphUri);
        if (null == memo) {
            try {
                memo = this.retrieveMemo(graphUri, sc);
            }
            catch (SailException e) {
                throw new RippleException((Throwable)e);
            }
            if (null == memo) {
                this.memos.put(graphUri, this.miss);
            } else {
                this.memos.put(graphUri, memo);
            }
        }
        return memo;
    }

    public void setMemo(String graphUri, CacheEntry memo, SailConnection sc) throws RippleException {
        try {
            URI s = this.valueFactory.createURI(graphUri);
            Literal memoLit = this.valueFactory.createLiteral(memo.toString());
            sc.removeStatements((Resource)s, LinkedDataCache.CACHE_MEMO, null, new Resource[]{LinkedDataCache.CACHE_GRAPH});
            sc.addStatement((Resource)s, LinkedDataCache.CACHE_MEMO, (Value)memoLit, new Resource[]{LinkedDataCache.CACHE_GRAPH});
            this.memos.put(graphUri, memo);
        }
        catch (SailException e) {
            throw new RippleException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry retrieveMemo(String graphUri, SailConnection sc) throws SailException, RippleException {
        CloseableIteration iter = sc.getStatements((Resource)this.valueFactory.createURI(graphUri), LinkedDataCache.CACHE_MEMO, null, false, new Resource[]{LinkedDataCache.CACHE_GRAPH});
        try {
            if (!iter.hasNext()) {
                CacheEntry cacheEntry = null;
                return cacheEntry;
            }
            Literal obj = (Literal)((Statement)iter.next()).getObject();
            CacheEntry cacheEntry = new CacheEntry(obj.getLabel());
            return cacheEntry;
        }
        finally {
            iter.close();
        }
    }

    private class InMemoryCache
    extends LinkedHashMap<String, CacheEntry> {
        private final int maxCapacity;

        public InMemoryCache(int maxCapacity) {
            super(16, 0.75f, true);
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxCapacity;
        }
    }
}

