/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import java.util.regex.Pattern;

public class RegexMetricFilter
implements MetricFilter {
    private final Pattern includes;
    private final Pattern excludes;

    public RegexMetricFilter(String includes, String excludes) {
        this.includes = includes == null ? null : Pattern.compile(includes);
        this.excludes = excludes == null ? null : Pattern.compile(excludes);
    }

    public boolean matches(String s, Metric metric) {
        if (this.includes != null && this.excludes != null) {
            return this.includes.matcher(s).matches() && !this.excludes.matcher(s).matches();
        }
        if (this.includes != null) {
            return this.includes.matcher(s).matches();
        }
        if (this.excludes != null) {
            return !this.excludes.matcher(s).matches();
        }
        return true;
    }
}

