/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.tinkerpop.rexster.server.RexsterProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ShutdownManager {
    protected final Logger logger = Logger.getLogger(ShutdownManager.class);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final AtomicBoolean shutdownComplete = new AtomicBoolean(false);
    protected final Collection<ShutdownListener> internalShutdownListeners = new ArrayList<ShutdownListener>();
    protected Collection<ShutdownListener> shutdownListeners = null;
    public static final String COMMAND_SHUTDOWN_WAIT = "sw";
    public static final String COMMAND_SHUTDOWN_NO_WAIT = "s";
    public static final String COMMAND_STATUS = "status";
    private final int port;
    private final String host;
    private int lastPort;
    private String lastHost;
    private ShutdownSocketListener shutdownSocketListener;

    public ShutdownManager(String host, int port) {
        this.port = port;
        this.host = host;
    }

    public ShutdownManager(final RexsterProperties properties) {
        this(properties.getRexsterShutdownHost(), properties.getRexsterShutdownPort());
        properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                ShutdownManager.this.updateSettings(properties.getRexsterShutdownHost(), properties.getRexsterShutdownPort());
            }
        });
    }

    public void updateSettings(String host, int port) {
        if (!host.equals(this.lastHost) || port != this.lastPort) {
            this.shutdownSocketListener.updateSettings(host, port);
        }
        this.lastHost = host;
        this.lastPort = port;
    }

    public void registerShutdownListener(ShutdownListener shutdownListener) {
        if (this.shutdownListeners == null) {
            this.shutdownListeners = new ArrayList<ShutdownListener>();
        }
        this.shutdownListeners.add(shutdownListener);
    }

    public final void start() throws Exception {
        this.shutdownSocketListener = new ShutdownSocketListener(this.host, this.port);
        Thread shutdownSocketThread = new Thread((Runnable)this.shutdownSocketListener, "ShutdownListener-" + this.host + ":" + this.port);
        shutdownSocketThread.setDaemon(true);
        shutdownSocketThread.start();
        this.internalShutdownListeners.add(this.shutdownSocketListener);
        final Thread shutdownHook = new Thread((Runnable)new ShutdownHookHandler(), "JVM Shutdown Hook");
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.logger.debug((Object)"Registered JVM shutdown hook");
        this.internalShutdownListeners.add(new ShutdownListener(){

            @Override
            public void shutdown() {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
                ShutdownManager.this.logger.debug((Object)"Removed JVM shutdown hook");
            }

            public String toString() {
                return "JVM Shutdown Hook Remover";
            }
        });
    }

    public final void waitForShutdown() {
        if (this.shutdownComplete.get()) {
            return;
        }
        try {
            this.shutdownLatch.await();
        }
        catch (InterruptedException e) {
            this.logger.warn((Object)"Interrupted waiting for shutdown condition", (Throwable)e);
        }
    }

    public final void shutdown() {
        boolean shuttingDown = this.shutdownRequested.getAndSet(true);
        if (shuttingDown) {
            if (this.shutdownComplete.get()) {
                this.logger.info((Object)"Already shut down, ignoring duplicate request");
            } else {
                this.logger.info((Object)"Already shutting down, ignoring duplicate request");
            }
            return;
        }
        this.preShutdownListeners();
        this.runShutdownHandlers(this.shutdownListeners);
        this.runShutdownHandlers(this.internalShutdownListeners);
        this.postShutdownListeners();
        this.shutdownComplete.set(true);
        this.shutdownLatch.countDown();
    }

    protected void preShutdownListeners() {
    }

    protected void postShutdownListeners() {
    }

    protected void sortShutdownListeners(List<ShutdownListener> shutdownListeners) {
    }

    protected final void runShutdownHandlers(Collection<ShutdownListener> shutdownListeners) {
        ArrayList<ShutdownListener> shutdownListenersClone = new ArrayList<ShutdownListener>(shutdownListeners);
        this.sortShutdownListeners(shutdownListenersClone);
        for (ShutdownListener shutdownListener : shutdownListenersClone) {
            try {
                this.logger.info((Object)("Calling ShutdownListener: " + shutdownListener));
                shutdownListener.shutdown();
                this.logger.info((Object)("ShutdownListener " + shutdownListener + " complete"));
            }
            catch (Exception e) {
                this.logger.warn((Object)("ShutdownListener " + shutdownListener + " threw an exception, continuing with shutdown"));
            }
        }
    }

    private class ShutdownHookHandler
    implements Runnable {
        private ShutdownHookHandler() {
        }

        @Override
        public void run() {
            ShutdownManager.this.logger.info((Object)"JVM shutdown hook called");
            ShutdownManager.this.shutdown();
        }
    }

    public static interface ShutdownListener {
        public void shutdown();
    }

    private class ShutdownSocketHandler
    implements Runnable {
        private final Socket shutdownConnection;

        public ShutdownSocketHandler(Socket shutdownConnection) {
            this.shutdownConnection = shutdownConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shutdownNoWait = false;
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.shutdownConnection.getInputStream()));
                PrintWriter writer = new PrintWriter(this.shutdownConnection.getOutputStream());
                try {
                    String receivedCommand = reader.readLine();
                    if (ShutdownManager.COMMAND_SHUTDOWN_WAIT.equals(receivedCommand)) {
                        ShutdownManager.this.logger.info((Object)"Received request for shutdown");
                        writer.println("Rexster Server shutting down...");
                        writer.flush();
                        ShutdownManager.this.shutdown();
                        writer.println("Rexster Server shutdown complete");
                    } else if (ShutdownManager.COMMAND_SHUTDOWN_NO_WAIT.equals(receivedCommand)) {
                        ShutdownManager.this.logger.info((Object)"Received request for shutdown");
                        writer.println("Rexster Server is starting shutdown (check status of shutdown with --status option)");
                        shutdownNoWait = true;
                    } else if (ShutdownManager.COMMAND_STATUS.equals(receivedCommand)) {
                        ShutdownManager.this.logger.debug((Object)"Received request for status");
                        if (ShutdownManager.this.shutdownRequested.get()) {
                            writer.println("Rexster Server is shutting down");
                        } else {
                            writer.println("Rexster Server is running");
                        }
                    } else {
                        writer.println(new Date() + ": Unknown command '" + receivedCommand + "'");
                    }
                }
                finally {
                    writer.flush();
                    IOUtils.closeQuietly((Reader)reader);
                    IOUtils.closeQuietly((Writer)writer);
                }
            }
            catch (IOException e) {
                ShutdownManager.this.logger.warn((Object)"Exception while handling connection to shutdown socket, ignoring", (Throwable)e);
            }
            finally {
                if (this.shutdownConnection != null) {
                    try {
                        this.shutdownConnection.close();
                    }
                    catch (IOException iOException) {}
                }
                if (shutdownNoWait) {
                    ShutdownManager.this.shutdown();
                }
            }
        }
    }

    private class ShutdownSocketListener
    implements Runnable,
    ShutdownListener {
        private ServerSocket shutdownSocket;
        private InetAddress bindHost;
        private int port;

        private ShutdownSocketListener(String host, int port) {
            this.updateSettings(host, port);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void updateSettings(String host, int port) {
            if (this.shutdownSocket != null) {
                try {
                    this.shutdownSocket.close();
                }
                catch (IOException ioe) {
                    ShutdownManager.this.logger.warn((Object)String.format("Failure closing shutdown socket on %s:%s", host, port));
                }
                finally {
                    this.shutdownSocket = null;
                }
            }
            this.port = port;
            try {
                this.bindHost = InetAddress.getByName(host);
            }
            catch (UnknownHostException uhe) {
                throw new RuntimeException("Failed to create InetAddress for host '" + host + "'", uhe);
            }
            try {
                this.shutdownSocket = new ServerSocket(this.port, 10, this.bindHost);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Failed to create shutdown socket on '" + this.bindHost + "' and " + this.port, ioe);
            }
            ShutdownManager.this.logger.info((Object)("Bound shutdown socket to " + this.bindHost + ":" + this.port + ". Starting listener thread for shutdown requests."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.shutdownSocket.isClosed()) {
                    try {
                        Socket connection = this.shutdownSocket.accept();
                        ShutdownSocketHandler shutdownSocketHandler = new ShutdownSocketHandler(connection);
                        Thread shutdownRequestThread = new Thread((Runnable)shutdownSocketHandler, "ShutdownManager-" + connection.getInetAddress() + ":" + connection.getPort());
                        shutdownRequestThread.setDaemon(true);
                        shutdownRequestThread.start();
                    }
                    catch (SocketException se) {
                        if (this.shutdownSocket.isClosed()) {
                            ShutdownManager.this.logger.info((Object)("Caught SocketException on shutdownSocket, assuming close() was called: " + se.getMessage()));
                            continue;
                        }
                        ShutdownManager.this.logger.warn((Object)("Exception while handling connection to shutdown socket, ignoring: " + se.getMessage()));
                    }
                    catch (IOException ioe) {
                        ShutdownManager.this.logger.warn((Object)"Exception while handling connection to shutdown socket, ignoring", (Throwable)ioe);
                    }
                }
            }
            finally {
                this.shutdown();
            }
        }

        @Override
        public void shutdown() {
            if (!this.shutdownSocket.isClosed()) {
                try {
                    this.shutdownSocket.close();
                    ShutdownManager.this.logger.debug((Object)("Closed shutdown socket " + this.bindHost + ":" + this.port));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "ShutdownListener [bindHost=" + this.bindHost + ", port=" + this.port + "]";
        }
    }
}

