/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.tinkerpop.rexster.server.RexsterCommandLine;
import com.tinkerpop.rexster.server.RexsterProperties;
import java.io.File;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RexsterSettings {
    public static final int DEFAULT_HTTP_PORT = 8182;
    public static final int DEFAULT_SHUTDOWN_PORT = 8183;
    public static final int DEFAULT_REXPRO_PORT = 8184;
    public static final String DEFAULT_WEB_ROOT_PATH = "public";
    public static final String DEFAULT_BASE_URI = "http://localhost";
    public static final long DEFAULT_REXPRO_SESSION_MAX_IDLE = 1790000L;
    public static final long DEFAULT_REXPRO_SESSION_CHECK_INTERVAL = 3000000L;
    public static final long DEFAULT_CONFIG_CHECK_INTERVAL = 10000L;
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final String COMMAND_START = "start";
    public static final String COMMAND_VERSION = "version";
    public static final String COMMAND_STOP = "stop";
    public static final String COMMAND_STATUS = "status";
    public static final String COMMAND_HELP = "help";
    private final RexsterCommandLine line;

    public RexsterSettings(String[] arguments) {
        this.line = RexsterSettings.getCliInput(RexsterSettings.cleanArguments(arguments));
    }

    public RexsterCommandLine getCommand() {
        return this.line;
    }

    public String getPrimeCommand() {
        if (this.line.getCommand().hasOption(COMMAND_START)) {
            return COMMAND_START;
        }
        if (this.line.getCommand().hasOption(COMMAND_VERSION)) {
            return COMMAND_VERSION;
        }
        if (this.line.getCommand().hasOption(COMMAND_STOP)) {
            return COMMAND_STOP;
        }
        if (this.line.getCommand().hasOption(COMMAND_STATUS)) {
            return COMMAND_STATUS;
        }
        return COMMAND_HELP;
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("rexster", this.line.getCommandOptions());
    }

    public boolean isDebug() {
        return this.line.hasCommandParameters() && this.line.getCommandParameters().hasOption("debug");
    }

    public File getRexsterXmlFile() {
        String rexsterXmlFileLocation = this.getRexsterXmlFileString();
        return new File(rexsterXmlFileLocation);
    }

    public RexsterProperties getProperties() {
        String rexsterXmlFileLocation = this.getRexsterXmlFileString();
        RexsterProperties properties = new RexsterProperties(rexsterXmlFileLocation);
        if (this.line.hasCommandParameters() && this.line.getCommandParameters().hasOption("webroot")) {
            properties.addOverride("http.web-root", this.line.getCommandParameters().getOptionValue("webroot"));
        }
        properties.addOverride("debug", this.isDebug());
        return properties;
    }

    private String getRexsterXmlFileString() {
        boolean rexsterXmlConfiguredFromCommandLine = this.line.hasCommandParameters() && this.line.getCommandParameters().hasOption("configuration");
        return rexsterXmlConfiguredFromCommandLine ? this.line.getCommandParameters().getOptionValue("configuration") : "config" + File.separator + "rexster.xml";
    }

    private static Options getCliOptions() {
        Option help = new Option("h", COMMAND_HELP, false, "print this message");
        OptionBuilder.withArgName((String)"parameters");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withDescription((String)"start rexster (learn more with start -h)");
        OptionBuilder.withLongOpt((String)COMMAND_START);
        Option rexsterStart = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"parameters");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withDescription((String)"stop rexster (learn more with stop -h)");
        OptionBuilder.withLongOpt((String)COMMAND_STOP);
        Option rexsterStop = OptionBuilder.create((String)"x");
        OptionBuilder.withArgName((String)"parameters");
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withDescription((String)"status of rexster (learn more with status -h)");
        OptionBuilder.withLongOpt((String)COMMAND_STATUS);
        Option rexsterStatus = OptionBuilder.create((String)"u");
        Option rexsterVersion = new Option("v", COMMAND_VERSION, false, "print the version of rexster server");
        Options options = new Options();
        options.addOption(rexsterStart);
        options.addOption(rexsterStop);
        options.addOption(rexsterStatus);
        options.addOption(rexsterVersion);
        options.addOption(help);
        return options;
    }

    private static Options getStartCliOptions() {
        Option help = new Option("h", COMMAND_HELP, false, "print this message");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given file for rexster.xml");
        OptionBuilder.withLongOpt((String)"configuration");
        Option rexsterFile = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"override port used for rexster-server-port in rexster.xml");
        OptionBuilder.withLongOpt((String)"rexsterport");
        Option webServerPort = OptionBuilder.create((String)"rp");
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"override web-root in rexster.xml");
        OptionBuilder.withLongOpt((String)"webroot");
        Option webRoot = OptionBuilder.create((String)"wr");
        Option debug = new Option("d", "debug", false, "run rexster with full console logging output from jersey");
        Options options = new Options();
        options.addOption(help);
        options.addOption(rexsterFile);
        options.addOption(webServerPort);
        options.addOption(webRoot);
        options.addOption(debug);
        return options;
    }

    private static Options getStopCliOptions() {
        Option help = new Option("h", COMMAND_HELP, false, "print this message");
        OptionBuilder.withArgName((String)"host-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"rexster web server hostname or ip address (default is 127.0.0.1)");
        OptionBuilder.withLongOpt((String)"rexsterhost");
        Option rexsterFile = OptionBuilder.create((String)"rh");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"rexster web server shutdown port (default is 8183)");
        OptionBuilder.withLongOpt((String)"rexsterport");
        Option webServerPort = OptionBuilder.create((String)"rp");
        Option stopAndWait = new Option("w", "wait", false, "wait for server confirmation of shutdown");
        Options options = new Options();
        options.addOption(help);
        options.addOption(rexsterFile);
        options.addOption(webServerPort);
        options.addOption(stopAndWait);
        return options;
    }

    private static Options getStatusCliOptions() {
        Option help = new Option("h", COMMAND_HELP, false, "print this message");
        OptionBuilder.withArgName((String)"host-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"rexster web server hostname or ip address (default is 127.0.0.1)");
        OptionBuilder.withLongOpt((String)"rexsterhost");
        Option rexsterFile = OptionBuilder.create((String)"rh");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"rexster web server status port (default is 8183)");
        OptionBuilder.withLongOpt((String)"rexsterport");
        Option webServerPort = OptionBuilder.create((String)"rp");
        Options options = new Options();
        options.addOption(help);
        options.addOption(rexsterFile);
        options.addOption(webServerPort);
        return options;
    }

    private static RexsterCommandLine getCliInput(String[] args) {
        HelpFormatter formatter;
        Options options = RexsterSettings.getCliOptions();
        GnuParser parser = new GnuParser();
        Options innerOptions = null;
        CommandLine line = null;
        CommandLine innerLine = null;
        String commandText = "";
        try {
            String[] optionValues;
            line = parser.parse(options, args, true);
            if (line.hasOption(COMMAND_START)) {
                commandText = COMMAND_START;
                innerOptions = RexsterSettings.getStartCliOptions();
                optionValues = line.getOptionValues(COMMAND_START);
                if (optionValues != null && optionValues.length > 0) {
                    innerLine = parser.parse(innerOptions, optionValues, true);
                }
            } else if (line.hasOption(COMMAND_STOP)) {
                commandText = COMMAND_STOP;
                innerOptions = RexsterSettings.getStopCliOptions();
                optionValues = line.getOptionValues(COMMAND_STOP);
                if (optionValues != null && optionValues.length > 0) {
                    innerLine = parser.parse(innerOptions, optionValues, true);
                }
            } else if (line.hasOption(COMMAND_STATUS)) {
                commandText = COMMAND_STATUS;
                innerOptions = RexsterSettings.getStatusCliOptions();
                optionValues = line.getOptionValues(COMMAND_STATUS);
                if (optionValues != null && optionValues.length > 0) {
                    innerLine = parser.parse(innerOptions, optionValues, true);
                }
            }
        }
        catch (ParseException exp) {
            HelpFormatter formatter2 = new HelpFormatter();
            formatter2.printHelp("rexster", options);
            System.exit(0);
        }
        if (line.hasOption(COMMAND_HELP) && (line.hasOption(COMMAND_START) || line.hasOption(COMMAND_STATUS) || line.hasOption(COMMAND_STOP))) {
            formatter = new HelpFormatter();
            formatter.printHelp("rexster - " + commandText, innerOptions);
            System.exit(0);
        } else if (line.hasOption(COMMAND_HELP)) {
            formatter = new HelpFormatter();
            formatter.printHelp("rexster", options);
            System.exit(0);
        }
        return new RexsterCommandLine(line, innerLine, options);
    }

    private static String[] cleanArguments(String[] arguments) {
        ArrayList<String> cleanedArguments = new ArrayList<String>();
        if (arguments != null && arguments.length > 0) {
            if (!(arguments[0].equals("-start") || arguments[0].equals("--start") || arguments[0].equals("-s"))) {
                for (int ix = 0; ix < arguments.length; ++ix) {
                    if (!arguments[ix].equals("-webroot")) {
                        cleanedArguments.add(arguments[ix]);
                        continue;
                    }
                    ++ix;
                }
            } else {
                for (String argument : arguments) {
                    cleanedArguments.add(argument);
                }
            }
        }
        String[] cleanedArgumentsAsArray = new String[cleanedArguments.size()];
        cleanedArguments.toArray(cleanedArgumentsAsArray);
        return cleanedArgumentsAsArray;
    }
}

