/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.server.XmlRexsterApplication;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;

@Provider
public class RexsterApplicationProvider
extends AbstractHttpContextInjectable<RexsterApplication>
implements InjectableProvider<Context, Type> {
    private static RexsterApplication rexster;
    private static XMLConfiguration configurationProperties;

    public RexsterApplicationProvider(@Context ServletContext servletContext, @Context ServletConfig servletConfig) {
        if (rexster == null) {
            if (configurationProperties == null) {
                configurationProperties = new XMLConfiguration();
            }
            String rexsterXmlFile = servletConfig.getInitParameter("com.tinkerpop.rexster.config");
            try {
                configurationProperties.load(servletContext.getResourceAsStream(rexsterXmlFile));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(String.format("Could not load %s properties file. Message: %s", rexsterXmlFile, e.getMessage()), e);
            }
            List graphConfigs = configurationProperties.configurationsAt("graphs.graph");
            rexster = new XmlRexsterApplication(graphConfigs);
        }
    }

    public RexsterApplication getValue(HttpContext c) {
        return rexster;
    }

    public RexsterApplication getValue() {
        return rexster;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    public Injectable getInjectable(ComponentContext ic, Context context, Type type) {
        if (type.equals(RexsterApplication.class)) {
            return this;
        }
        return null;
    }
}

