/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server;

import com.codahale.metrics.JmxAttributeGauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jersey.InstrumentedResourceMethodDispatchAdapter;
import com.codahale.metrics.servlets.MetricsServlet;
import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.ClassNamesResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.tinkerpop.rexster.EdgeResource;
import com.tinkerpop.rexster.GraphResource;
import com.tinkerpop.rexster.IndexResource;
import com.tinkerpop.rexster.KeyIndexResource;
import com.tinkerpop.rexster.PrefixResource;
import com.tinkerpop.rexster.RexsterResource;
import com.tinkerpop.rexster.RootResource;
import com.tinkerpop.rexster.VertexResource;
import com.tinkerpop.rexster.filter.AbstractSecurityFilter;
import com.tinkerpop.rexster.filter.DefaultSecurityFilter;
import com.tinkerpop.rexster.filter.HeaderResponseFilter;
import com.tinkerpop.rexster.server.GrizzlyIoStrategyFactory;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.server.RexsterProperties;
import com.tinkerpop.rexster.server.RexsterServer;
import com.tinkerpop.rexster.server.metrics.AbstractReporterConfig;
import com.tinkerpop.rexster.servlet.DogHouseServlet;
import com.tinkerpop.rexster.servlet.EvaluatorServlet;
import com.tinkerpop.rexster.servlet.RexsterStaticHttpHandler;
import java.io.File;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public class HttpRexsterServer
implements RexsterServer {
    private static final Logger logger = Logger.getLogger(HttpRexsterServer.class);
    private RexsterApplication app;
    private final RexsterProperties properties;
    private Integer rexsterServerPort;
    private String rexsterServerHost;
    private String webRootPath;
    private String baseUri;
    private int maxWorkerThreadPoolSize;
    private int coreWorkerThreadPoolSize;
    private int maxKernalThreadPoolSize;
    private int coreKernalThreadPoolSize;
    private int maxPostSize;
    private int maxHeaderSize;
    private int uploadTimeoutMillis;
    private boolean enableJmx;
    private String ioStrategy;
    private final HttpServer httpServer;
    private boolean debugMode;
    private boolean enableHttpReporter;
    private boolean enableDogHouse;
    private String convertRateTo;
    private String convertDurationTo;
    private String securityFilterType;
    private String defaultCharacterEncoding;
    private HttpHandler staticHttpHandler = null;
    private WebappContext wacDogHouse;
    private WebappContext wacJersey;
    private WebappContext wacMetrics;
    private String lastDefaultCharacterEncoding;
    private String lastSecurityFilterType;
    private Integer lastRexsterServerPort;
    private String lastRexsterServerHost;
    private String lastIoStrategy;
    private boolean lastEnableJmx;
    private int lastMaxWorkerThreadPoolSize;
    private int lastCoreWorkerThreadPoolSize;
    private int lastMaxKernalThreadPoolSize;
    private int lastCoreKernalThreadPoolSize;
    private boolean lastEnableDogHouse;
    private String lastWebRootPath;
    private String lastBaseUri;
    private boolean lastDebugMode;
    private boolean lastEnableHttpReporter;

    public HttpRexsterServer(XMLConfiguration configuration) {
        this(new RexsterProperties(configuration));
    }

    public HttpRexsterServer(RexsterProperties properties) {
        this.properties = properties;
        this.httpServer = new HttpServer();
        this.updateSettings(properties.getConfiguration());
        properties.addListener(new RexsterProperties.RexsterPropertiesListener(){

            @Override
            public void propertiesChanged(XMLConfiguration configuration) {
                HttpRexsterServer.this.lastRexsterServerHost = HttpRexsterServer.this.rexsterServerHost;
                HttpRexsterServer.this.lastRexsterServerPort = HttpRexsterServer.this.rexsterServerPort;
                HttpRexsterServer.this.lastEnableJmx = HttpRexsterServer.this.enableJmx;
                HttpRexsterServer.this.lastIoStrategy = HttpRexsterServer.this.ioStrategy;
                HttpRexsterServer.this.lastMaxWorkerThreadPoolSize = HttpRexsterServer.this.maxWorkerThreadPoolSize;
                HttpRexsterServer.this.lastCoreWorkerThreadPoolSize = HttpRexsterServer.this.coreWorkerThreadPoolSize;
                HttpRexsterServer.this.lastMaxKernalThreadPoolSize = HttpRexsterServer.this.maxKernalThreadPoolSize;
                HttpRexsterServer.this.lastCoreKernalThreadPoolSize = HttpRexsterServer.this.coreKernalThreadPoolSize;
                HttpRexsterServer.this.lastEnableDogHouse = HttpRexsterServer.this.enableDogHouse;
                HttpRexsterServer.this.lastWebRootPath = HttpRexsterServer.this.webRootPath;
                HttpRexsterServer.this.lastBaseUri = HttpRexsterServer.this.baseUri;
                HttpRexsterServer.this.lastSecurityFilterType = HttpRexsterServer.this.securityFilterType;
                HttpRexsterServer.this.lastDefaultCharacterEncoding = HttpRexsterServer.this.defaultCharacterEncoding;
                HttpRexsterServer.this.lastDebugMode = HttpRexsterServer.this.debugMode;
                HttpRexsterServer.this.lastEnableHttpReporter = HttpRexsterServer.this.enableHttpReporter;
                HttpRexsterServer.this.updateSettings(configuration);
                try {
                    HttpRexsterServer.this.reconfigure(HttpRexsterServer.this.app);
                }
                catch (Exception ex) {
                    logger.error((Object)"Could not modify Rexster configuration.  Please restart Rexster to allow changes to be applied.", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void stop() throws Exception {
        this.httpServer.stop();
    }

    @Override
    public void start(RexsterApplication application) throws Exception {
        this.app = application;
        this.reconfigure(application);
    }

    public void reconfigure(RexsterApplication application) throws Exception {
        if (this.hasAnythingChanged()) {
            if (this.wacJersey != null) {
                this.wacJersey.undeploy();
                this.wacJersey = null;
            }
            if (this.wacDogHouse != null) {
                this.wacDogHouse.undeploy();
                this.wacDogHouse = null;
            }
            if (this.wacMetrics != null) {
                this.wacMetrics.undeploy();
                this.wacMetrics = null;
            }
        }
        this.deployRestApi(application);
        this.deployStaticResourceServer();
        this.deployDogHouse(application);
        this.deployMetricsAdmin(application);
        this.configureNetworkListener();
        if (this.hasEnableJmxChanged()) {
            this.httpServer.getServerConfiguration().setJmxEnabled(this.enableJmx);
            this.manageJmxMetrics(application, this.enableJmx);
            logger.info((Object)(this.enableJmx ? "JMX enabled on HTTP/REST." : "JMX disabled on HTTP/REST."));
        }
        if (!this.httpServer.isStarted()) {
            this.httpServer.start();
        }
        logger.info((Object)("Rexster Server running on: [" + this.baseUri + ":" + this.rexsterServerPort + "]"));
    }

    private void manageJmxMetrics(RexsterApplication application, boolean register) throws MalformedObjectNameException {
        MetricRegistry metricRegistry = application.getMetricRegistry();
        HttpRexsterServer.manageMetricsFromJmx(metricRegistry, register);
        logger.info((Object)(register ? "Registered JMX Metrics." : "Removed JMX Metrics."));
    }

    private boolean hasAnythingChanged() {
        return this.hasRestConfigurationsChanged() || this.hasWebRootChanged() || this.hasEnableDogHouseChanged() || this.hasBaseUriChanged() || this.hasEnableHttpReporterChanged();
    }

    private boolean hasWebRootChanged() {
        return !this.webRootPath.equals(this.lastWebRootPath);
    }

    private boolean hasPortHostChanged() {
        return !this.rexsterServerPort.equals(this.lastRexsterServerPort) || !this.lastRexsterServerHost.equals(this.rexsterServerHost);
    }

    private boolean hasEnableJmxChanged() {
        return this.enableJmx != this.lastEnableJmx;
    }

    private boolean hasEnableDogHouseChanged() {
        return this.enableDogHouse != this.lastEnableDogHouse;
    }

    private boolean hasBaseUriChanged() {
        return !this.baseUri.equals(this.lastBaseUri);
    }

    private boolean hasIoStrategyChanged() {
        return !this.ioStrategy.equals(this.lastIoStrategy);
    }

    private boolean hasThreadPoolSizeChanged() {
        return this.maxKernalThreadPoolSize != this.lastMaxKernalThreadPoolSize || this.maxWorkerThreadPoolSize != this.lastMaxWorkerThreadPoolSize || this.coreKernalThreadPoolSize != this.lastCoreKernalThreadPoolSize || this.coreWorkerThreadPoolSize != this.lastCoreWorkerThreadPoolSize;
    }

    private boolean hasRestConfigurationsChanged() {
        return !this.securityFilterType.equals(this.lastSecurityFilterType) || !this.defaultCharacterEncoding.equals(this.lastDefaultCharacterEncoding) || this.debugMode != this.lastDebugMode;
    }

    private boolean hasEnableHttpReporterChanged() {
        return this.enableHttpReporter != this.lastEnableHttpReporter;
    }

    private void updateSettings(XMLConfiguration configuration) {
        this.debugMode = configuration.getBoolean("debug", false);
        this.enableDogHouse = configuration.getBoolean("http.enable-doghouse", true);
        this.enableHttpReporter = configuration.getBoolean("http-reporter-enabled", false);
        this.convertRateTo = configuration.getString("http-reporter-convert", AbstractReporterConfig.DEFAULT_TIME_UNIT.toString());
        this.convertDurationTo = configuration.getString("http-reporter-duration", AbstractReporterConfig.DEFAULT_TIME_UNIT.toString());
        this.rexsterServerPort = configuration.getInteger("http.server-port", new Integer(8182));
        this.rexsterServerHost = configuration.getString("http.server-host", "0.0.0.0");
        this.webRootPath = configuration.getString("http.web-root", "public");
        this.baseUri = configuration.getString("http.base-uri", "http://localhost");
        this.coreWorkerThreadPoolSize = configuration.getInt("http.thread-pool.worker.core-size", 8);
        this.maxWorkerThreadPoolSize = configuration.getInt("http.thread-pool.worker.max-size", 8);
        this.coreKernalThreadPoolSize = configuration.getInt("http.thread-pool.kernal.core-size", 4);
        this.maxKernalThreadPoolSize = configuration.getInt("http.thread-pool.kernal.max-size", 4);
        this.maxPostSize = configuration.getInt("http.max-post-size", 0x200000);
        this.maxHeaderSize = configuration.getInt("http.max-header-size", 8192);
        this.uploadTimeoutMillis = configuration.getInt("http.upload-timeout-millis", 300000);
        this.enableJmx = configuration.getBoolean("http.enable-jmx", false);
        this.ioStrategy = configuration.getString("http.io-strategy", "leader-follower");
        this.defaultCharacterEncoding = configuration.getString("http.character-set", "ISO-8859-1");
        SubnodeConfiguration securityConfiguration = null;
        try {
            securityConfiguration = configuration.configurationAt("security.authentication");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.securityFilterType = securityConfiguration != null ? securityConfiguration.getString("type") : "none";
    }

    private static void manageMetricsFromJmx(MetricRegistry metricRegistry, boolean register) throws MalformedObjectNameException {
        String jmxObjectMemoryManager = "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=HeapMemoryManager,name=MemoryManager";
        String metricGroupMemoryManager = "heap-memory-manager";
        String[] heapMemoryManagerMetrics = new String[]{"pool-allocated-bytes", "pool-released-bytes", "real-allocated-bytes", "total-allocated-bytes"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/TCPNIOTransport[RexPro],type=HeapMemoryManager,name=MemoryManager", "heap-memory-manager", heapMemoryManagerMetrics, register);
        String jmxObjectHttpServerFilter = "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=HttpServerFilter,name=HttpServerFilter";
        String metricGroupHttpServerFilter = "http-server";
        String[] httpServerManagerMetrics = new String[]{"current-suspended-request-count", "requests-cancelled-count", "requests-completed-count", "requests-received-count", "requests-timed-out-count"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=HttpServerFilter,name=HttpServerFilter", "http-server", httpServerManagerMetrics, register);
        String jmxObjectHttpKeepAlive = "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=KeepAlive,name=Keep-Alive";
        String metricGroupHttpKeepAlive = "http-keep-alive";
        String[] httpKeepAliveMetrics = new String[]{"hits-count", "idle-timeout-seconds", "live-connections-count", "max-requests-count", "refuses-count", "timeouts-count"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=KeepAlive,name=Keep-Alive", "http-keep-alive", httpKeepAliveMetrics, register);
        String jmxObjectNetworkListener = "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer],type=NetworkListener,name=NetworkListener[grizzly]";
        String metricGroupNetworkListener = "network-listener";
        String[] networkListenerMetrics = new String[]{"chunking-enabled", "host", "idle-timeout-seconds", "max-http-header-size", "max-pending-bytes", "port"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer],type=NetworkListener,name=NetworkListener[grizzly]", "network-listener", networkListenerMetrics, register);
        String jmxObjectTcpNioTransport = "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=TCPNIOTransport,name=Transport";
        String metricGroupTcpNioTransport = "tcp-nio-transport";
        String[] tcpNioTransportMetrics = new String[]{"bound-addresses", "bytes-read", "bytes-written", "client-connect-timeout-millis", "io-strategy", "open-connections-count", "read-buffer-size", "selector-threads-count", "server-socket-so-timeout", "total-connections-count", "write-buffer-size"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]],type=TCPNIOTransport,name=Transport", "tcp-nio-transport", tcpNioTransportMetrics, register);
        String jmxObjectThreadPool = "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]]/TCPNIOTransport[Transport],type=ThreadPool,name=ThreadPool";
        String metricGroupThreadPool = "thread-pool";
        String[] threadPoolMetrics = new String[]{"thread-pool-allocated-thread-count", "thread-pool-core-pool-size", "thread-pool-max-num-threads", "thread-pool-queued-task-count", "thread-pool-task-queue-overflow-count", "thread-pool-total-allocated-thread-count", "thread-pool-total-completed-tasks-count", "thread-pool-type"};
        HttpRexsterServer.manageJmxKeysAsMetric(metricRegistry, "org.glassfish.grizzly:pp=/gmbal-root/HttpServer[HttpServer]/NetworkListener[NetworkListener[grizzly]]/TCPNIOTransport[Transport],type=ThreadPool,name=ThreadPool", "thread-pool", threadPoolMetrics, register);
    }

    private static void manageJmxKeysAsMetric(MetricRegistry metricRegistry, String jmxObjectName, String metricGroup, String[] metricKeys, boolean register) throws MalformedObjectNameException {
        for (String metricKey : metricKeys) {
            if (register) {
                HttpRexsterServer.registerJmxKeyAsMetric(metricRegistry, metricGroup, jmxObjectName, metricKey);
                continue;
            }
            HttpRexsterServer.deregisterJmxKeyAsMetric(metricRegistry, metricGroup, metricKey);
        }
    }

    private static void registerJmxKeyAsMetric(MetricRegistry metricRegistry, String metricGroup, String jmxObjectName, String jmxAttributeName) throws MalformedObjectNameException {
        metricRegistry.register(MetricRegistry.name((String)"http", (String[])new String[]{"core", metricGroup, jmxAttributeName}), (Metric)new JmxAttributeGauge(new ObjectName(jmxObjectName), jmxAttributeName));
    }

    private static void deregisterJmxKeyAsMetric(MetricRegistry metricRegistry, String metricGroup, String jmxAttributeName) throws MalformedObjectNameException {
        metricRegistry.remove(MetricRegistry.name((String)"http", (String[])new String[]{"core", metricGroup, jmxAttributeName}));
    }

    private void deployRestApi(RexsterApplication application) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.hasAnythingChanged()) {
            this.wacJersey = new WebappContext("jersey", "");
            ResourceConfig rc = this.constructResourceConfig();
            rc.getSingletons().add(new SingletonTypeInjectableProvider<Context, RexsterApplication>(RexsterApplication.class, application){});
            rc.getSingletons().add(new InstrumentedResourceMethodDispatchAdapter(application.getMetricRegistry()));
            if (this.debugMode) {
                rc.getContainerRequestFilters().add(new LoggingFilter());
                rc.getContainerResponseFilters().add(new LoggingFilter());
            }
            rc.getContainerResponseFilters().add(new HeaderResponseFilter(this.defaultCharacterEncoding));
            if (!this.securityFilterType.equals("none")) {
                AbstractSecurityFilter securityFilter;
                if (this.securityFilterType.equals("default")) {
                    this.wacJersey.addContextInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", DefaultSecurityFilter.class.getName());
                    securityFilter = new DefaultSecurityFilter();
                } else {
                    this.wacJersey.addContextInitParameter("com.sun.jersey.spi.container.ContainerRequestFilters", this.securityFilterType);
                    Class<?> clazz = Class.forName(this.securityFilterType, true, Thread.currentThread().getContextClassLoader());
                    securityFilter = (AbstractSecurityFilter)((Object)clazz.newInstance());
                }
                ((AbstractSecurityFilter)securityFilter).configure(this.properties.getConfiguration());
                rc.getContainerRequestFilters().add(securityFilter);
            }
            ServletRegistration sg = this.wacJersey.addServlet("jersey", (Servlet)new ServletContainer((Application)rc));
            sg.addMapping(new String[]{"/*"});
            this.wacJersey.deploy(this.httpServer);
        }
    }

    private ResourceConfig constructResourceConfig() {
        ClassNamesResourceConfig rc = this.enableDogHouse ? new ClassNamesResourceConfig(new Class[]{EdgeResource.class, GraphResource.class, IndexResource.class, KeyIndexResource.class, PrefixResource.class, RexsterResource.class, RootResource.class, VertexResource.class}) : new ClassNamesResourceConfig(new Class[]{EdgeResource.class, GraphResource.class, IndexResource.class, KeyIndexResource.class, PrefixResource.class, RexsterResource.class, VertexResource.class});
        return rc;
    }

    private void deployStaticResourceServer() {
        if (this.hasAnythingChanged()) {
            ServerConfiguration config = this.httpServer.getServerConfiguration();
            String absoluteWebRootPath = new File(this.webRootPath).getAbsolutePath();
            if (this.staticHttpHandler != null) {
                config.removeHttpHandler(this.staticHttpHandler);
            }
            if (this.enableDogHouse) {
                this.staticHttpHandler = new RexsterStaticHttpHandler(absoluteWebRootPath);
                config.addHttpHandler(this.staticHttpHandler, new String[]{"/static"});
            }
        }
    }

    private void deployDogHouse(RexsterApplication application) {
        if (this.hasAnythingChanged() && this.enableDogHouse) {
            this.wacDogHouse = new WebappContext("doghouse", "");
            ServletRegistration sgDogHouse = this.wacDogHouse.addServlet("doghouse", (Servlet)new DogHouseServlet());
            sgDogHouse.addMapping(new String[]{"/doghouse/*"});
            sgDogHouse.setInitParameter("com.tinkerpop.rexster.config.rexsterApiBaseUri", this.baseUri + ":" + this.rexsterServerPort.toString());
            ServletRegistration sgDogHouseEval = this.wacDogHouse.addServlet("doghouse-evaluator", (Servlet)new EvaluatorServlet(application));
            sgDogHouseEval.addMapping(new String[]{"/doghouse/exec"});
            this.wacDogHouse.deploy(this.httpServer);
        }
    }

    private void deployMetricsAdmin(RexsterApplication application) {
        if (this.hasAnythingChanged() && this.enableHttpReporter) {
            this.wacMetrics = new WebappContext("metrics", "");
            this.wacMetrics.setAttribute("com.codahale.metrics.servlets.MetricsServlet.registry", (Object)application.getMetricRegistry());
            this.wacMetrics.addContextInitParameter("com.codahale.metrics.servlets.MetricsServlet.rateUnit", this.convertRateTo);
            this.wacMetrics.addContextInitParameter("com.codahale.metrics.servlets.MetricsServlet.durationUnit", this.convertDurationTo);
            ServletRegistration sgMetrics = this.wacMetrics.addServlet("metrics", (Servlet)new MetricsServlet());
            sgMetrics.addMapping(new String[]{"/metrics/*"});
            this.wacMetrics.deploy(this.httpServer);
        }
    }

    private void configureNetworkListener() throws Exception {
        boolean allowPortChange = true;
        NetworkListener listener = this.httpServer.getListener("grizzly");
        if (listener == null) {
            listener = new NetworkListener("grizzly", this.rexsterServerHost, this.rexsterServerPort.intValue());
            this.httpServer.addListener(listener);
            allowPortChange = false;
        }
        if (allowPortChange && this.hasPortHostChanged()) {
            listener.getTransport().unbindAll();
            listener.getTransport().bind(this.rexsterServerHost, this.rexsterServerPort.intValue());
            logger.info((Object)String.format("RexPro Server bound to [%s:%s]", this.rexsterServerHost, this.rexsterServerPort));
        }
        if (this.hasThreadPoolSizeChanged()) {
            ThreadPoolConfig workerThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(this.coreWorkerThreadPoolSize).setMaxPoolSize(this.maxWorkerThreadPoolSize);
            listener.getTransport().setWorkerThreadPoolConfig(workerThreadPoolConfig);
            ThreadPoolConfig kernalThreadPoolConfig = ThreadPoolConfig.defaultConfig().setCorePoolSize(this.coreKernalThreadPoolSize).setMaxPoolSize(this.maxKernalThreadPoolSize);
            listener.getTransport().setKernelThreadPoolConfig(kernalThreadPoolConfig);
            if (listener.getTransport().getKernelThreadPool() != null) {
                ((GrizzlyExecutorService)listener.getTransport().getKernelThreadPool()).reconfigure(kernalThreadPoolConfig);
            }
            if (listener.getTransport().getWorkerThreadPool() != null) {
                ((GrizzlyExecutorService)listener.getTransport().getWorkerThreadPool()).reconfigure(workerThreadPoolConfig);
            }
            logger.info((Object)String.format("HTTP/REST thread pool configuration: kernal[%s / %s] worker[%s / %s] ", this.coreKernalThreadPoolSize, this.maxKernalThreadPoolSize, this.coreWorkerThreadPoolSize, this.maxWorkerThreadPoolSize));
        }
        listener.setMaxPostSize(this.maxPostSize);
        listener.setMaxHttpHeaderSize(this.maxHeaderSize);
        listener.setUploadTimeout(this.uploadTimeoutMillis);
        listener.setDisableUploadTimeout(false);
        if (this.hasIoStrategyChanged()) {
            IOStrategy strategy = GrizzlyIoStrategyFactory.createIoStrategy(this.ioStrategy);
            listener.getTransport().setIOStrategy(strategy);
            logger.info((Object)String.format("Using %s IOStrategy for HTTP/REST.", strategy.getClass().getName()));
        }
    }
}

