/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.gremlin;

import com.tinkerpop.rexster.gremlin.GremlinEvaluationJob;
import com.tinkerpop.rexster.gremlin.GremlinFactory;
import com.tinkerpop.rexster.server.RexsterApplication;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.log4j.Logger;

public class GremlinSession
implements Runnable {
    private static final Logger logger = Logger.getLogger(GremlinSession.class);
    public static final int MAX_COMMANDS_WAITING = 128;
    protected Date lastTimeUsed = new Date();
    protected ScriptEngine scriptEngine;
    protected BlockingQueue<GremlinEvaluationJob> jobQueue = new ArrayBlockingQueue<GremlinEvaluationJob>(128);
    protected boolean sepukko = false;
    protected Thread runner = new Thread((Runnable)this, "GremlinSession");
    private String graphName;
    private RexsterApplication ra;

    public GremlinSession(String graphName, RexsterApplication ra) {
        this.graphName = graphName;
        this.ra = ra;
        this.runner.start();
    }

    @Override
    public void run() {
        try {
            do {
                if (this.scriptEngine == null) {
                    HashMap<String, Object> context = new HashMap<String, Object>();
                    context.put("g", this.ra.getApplicationGraph(this.graphName).getGraph());
                    this.scriptEngine = GremlinFactory.createGremlinScriptEngine(context);
                }
                GremlinEvaluationJob job = this.jobQueue.take();
                job.setResult(this.performEvaluation(job));
            } while (!this.sepukko);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public GremlinEvaluationJob evaluate(String script) {
        GremlinEvaluationJob job = new GremlinEvaluationJob(script);
        try {
            this.jobQueue.add(job);
            while (!job.isComplete()) {
                Thread.sleep(10L);
            }
            return job;
        }
        catch (InterruptedException e) {
            return job;
        }
    }

    public synchronized void reset() {
        this.scriptEngine = null;
    }

    public long getIdleTime() {
        return new Date().getTime() - this.lastTimeUsed.getTime();
    }

    public void die() {
        this.sepukko = true;
    }

    protected Object performEvaluation(GremlinEvaluationJob job) {
        try {
            this.lastTimeUsed = new Date();
            this.scriptEngine.getContext().setWriter(job.getOutputWriter());
            this.scriptEngine.getContext().setErrorWriter(job.getOutputWriter());
            return this.scriptEngine.eval(job.getScript());
        }
        catch (ScriptException e) {
            logger.error((Object)"ScriptEngine error running [%s]", (Throwable)e);
            return e;
        }
        catch (RuntimeException e) {
            logger.error((Object)"ScriptEngine error running [%s]", (Throwable)e);
            return e;
        }
    }
}

