/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.KeyIndexableGraph;
import com.tinkerpop.blueprints.util.wrappers.id.IdGraph;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;

public class IdGraphConfiguration
implements GraphConfiguration {
    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        SubnodeConfiguration specificConfiguration;
        String graphFile = context.getProperties().getString("graph-location", null);
        if (graphFile == null || graphFile.trim().length() == 0) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: graph-location");
        }
        RexsterApplicationGraph baseGraph = (RexsterApplicationGraph)context.getGraphs().get(graphFile);
        if (null == baseGraph) {
            throw new GraphConfigurationException("no such base graph for IdGraph: " + graphFile);
        }
        if (!(baseGraph.getGraph() instanceof KeyIndexableGraph)) {
            throw new GraphConfigurationException("base graph for IdGraph must be an instance of KeyIndexableGraph");
        }
        HierarchicalConfiguration graphSectionConfig = (HierarchicalConfiguration)context.getProperties();
        try {
            specificConfiguration = graphSectionConfig.configurationAt("properties");
        }
        catch (IllegalArgumentException iae) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: properties");
        }
        boolean supportVertexIds = specificConfiguration.getBoolean("supportVertexIds", true);
        boolean supportEdgeIds = specificConfiguration.getBoolean("supportEdgeIds", true);
        return new IdGraph((KeyIndexableGraph)baseGraph.getGraph(), supportVertexIds, supportEdgeIds);
    }
}

