/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.codahale.metrics.annotation.Timed;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONUtility;
import com.tinkerpop.rexster.AbstractSubResource;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.RexsterMediaType;
import com.tinkerpop.rexster.extension.ExtensionMethod;
import com.tinkerpop.rexster.extension.ExtensionPoint;
import com.tinkerpop.rexster.extension.ExtensionResponse;
import com.tinkerpop.rexster.extension.ExtensionSegmentSet;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.extension.RexsterExtension;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.util.ElementHelper;
import com.tinkerpop.rexster.util.RequestObjectHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

@Path(value="/graphs/{graphname}/edges")
public class EdgeResource
extends AbstractSubResource {
    private static Logger logger = Logger.getLogger(EdgeResource.class);

    public EdgeResource() {
        super(null);
    }

    public EdgeResource(UriInfo ui, HttpServletRequest req, RexsterApplication ra) {
        super(ra);
        this.httpServletRequest = req;
        this.uriInfo = ui;
    }

    @OPTIONS
    public Response optionsAllEdges() {
        return this.buildOptionsResponse(HttpMethod.GET.toString(), HttpMethod.POST.toString());
    }

    @GET
    @Produces(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.edges.collection.get", absolute=true)
    public Response getAllEdges(@PathParam(value="graphname") String graphName) {
        return this.getAllEdges(graphName, false);
    }

    @GET
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.collection.get", absolute=true)
    public Response getAllEdgesRexsterTypedJson(@PathParam(value="graphname") String graphName) {
        return this.getAllEdges(graphName, true);
    }

    private Response getAllEdges(String graphName, boolean showTypes) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        JSONObject theRequestObject = this.getRequestObject();
        Long start = RequestObjectHelper.getStartOffset((JSONObject)theRequestObject);
        Long end = RequestObjectHelper.getEndOffset((JSONObject)theRequestObject);
        GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
        Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)this.getRequestObject());
        String key = null;
        Object value = null;
        Object temp = theRequestObject.opt("key");
        if (null != temp) {
            key = temp.toString();
        }
        if (null != (temp = theRequestObject.opt("value"))) {
            value = ElementHelper.getTypedPropertyValue((Object)temp.toString());
        }
        boolean filtered = key != null && value != null;
        boolean wasInSection = false;
        long counter = 0L;
        try {
            JSONArray edgeArray = new JSONArray();
            Iterable edges = filtered ? graph.getEdges(key, value) : graph.getEdges();
            for (Edge edge : edges) {
                if (counter >= start && counter < end) {
                    wasInSection = true;
                    edgeArray.put((Object)GraphSONUtility.jsonFromElement((Element)edge, (Set)returnKeys, (GraphSONMode)mode));
                } else if (wasInSection) break;
                ++counter;
            }
            this.resultObject.put("results", (Object)edgeArray);
            this.resultObject.put("totalSize", edgeArray.length());
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        finally {
            rag.tryCommit();
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @OPTIONS
    @Path(value="/{id}")
    public Response optionsSingleEdge() {
        return this.buildOptionsResponse();
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @Timed(name="http.rest.edges.object.get", absolute=true)
    public Response getSingleEdge(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleEdge(graphName, id, false, false);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.edges.object.get", absolute=true)
    public Response getSingleEdgeRexsterJson(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleEdge(graphName, id, false, true);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.get", absolute=true)
    public Response getSingleEdgeRexsterTypedJson(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.getSingleEdge(graphName, id, true, true);
    }

    private Response getSingleEdge(String graphName, String id, boolean showTypes, boolean showHypermedia) {
        block7: {
            RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
            try {
                Edge edge = rag.getGraph().getEdge((Object)id);
                if (null != edge) {
                    JSONArray extensionsList;
                    JSONObject theRequestObject = this.getRequestObject();
                    GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
                    Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
                    this.resultObject.put("results", (Object)GraphSONUtility.jsonFromElement((Element)edge, (Set)returnKeys, (GraphSONMode)mode));
                    this.resultObject.put("queryTime", this.sh.stopWatch());
                    if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.EDGE, this.getUriPath())) != null) {
                        this.resultObject.put("extensions", (Object)extensionsList);
                    }
                    break block7;
                }
                String msg = "Edge with id [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
            finally {
                rag.tryCommit();
            }
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @HEAD
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/json"})
    public Response headEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeEdgeExtension(graphName, id, HttpMethod.HEAD);
    }

    @HEAD
    @Path(value="/{id}/{extension: .+}")
    public Response headEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.HEAD);
    }

    @PUT
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeEdgeExtension(graphName, id, HttpMethod.PUT);
    }

    @PUT
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeEdgeExtension(graphName, id, HttpMethod.PUT);
    }

    @PUT
    @Path(value="/{id}/{extension: .+}")
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.PUT);
    }

    @OPTIONS
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/json"})
    public Response optionsEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeEdgeExtension(graphName, id, HttpMethod.OPTIONS);
    }

    @OPTIONS
    @Path(value="/{id}/{extension: .+}")
    public Response optionsEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.OPTIONS);
    }

    @DELETE
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.edges.object.delete", absolute=true)
    public Response deleteEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeEdgeExtension(graphName, id, HttpMethod.DELETE);
    }

    @DELETE
    @Path(value="/{id}/{extension: .+}")
    @Timed(name="http.rest.edges.object.delete", absolute=true)
    public Response deleteEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.DELETE);
    }

    @POST
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        return this.executeEdgeExtension(graphName, id, HttpMethod.POST);
    }

    @POST
    @Path(value="/{id}/{extension: .+}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, MultivaluedMap<String, String> formParams) {
        this.setRequestObject(formParams);
        return this.executeEdgeExtension(graphName, id, HttpMethod.POST);
    }

    @POST
    @Path(value="/{id}/{extension: .+}")
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.POST);
    }

    @GET
    @Path(value="/{id}/{extension: .+}")
    @Timed(name="http.rest.edges.object.get", absolute=true)
    public Response getEdgeExtension(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        return this.executeEdgeExtension(graphName, id, HttpMethod.GET);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response executeEdgeExtension(String graphName, String id, HttpMethod httpMethodRequested) {
        Object returnValue;
        ExtensionMethod methodToCall;
        Edge edge = this.getRexsterApplicationGraph(graphName).getGraph().getEdge((Object)id);
        ExtensionSegmentSet extensionSegmentSet = this.parseUriForExtensionSegment(graphName, ExtensionPoint.EDGE);
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        if (!rag.isExtensionAllowed(extensionSegmentSet)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]"));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not configured for [" + graphName + "]");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        try {
            List<RexsterExtension> rexsterExtensions;
            try {
                rexsterExtensions = EdgeResource.findExtensionClasses(extensionSegmentSet);
            }
            catch (ServiceConfigurationError sce) {
                logger.error((Object)"ServiceLoader could not find a class referenced in com.tinkerpop.rexster.extension.RexsterExtension.");
                JSONObject error = this.generateErrorObject("Class specified in com.tinkerpop.rexster.extension.RexsterExtension could not be found.", sce);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            if (rexsterExtensions == null || rexsterExtensions.size() == 0) {
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            methodToCall = EdgeResource.findExtensionMethod(rexsterExtensions, ExtensionPoint.EDGE, extensionSegmentSet.getExtensionMethod(), httpMethodRequested);
            if (methodToCall == null) {
                if (httpMethodRequested == HttpMethod.OPTIONS) {
                    return this.buildOptionsResponse();
                }
                logger.error((Object)("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "].  Check com.tinkerpop.rexster.extension.RexsterExtension file in META-INF.services."));
                JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension was not found for [" + graphName + "] with a HTTP method of [" + httpMethodRequested.name() + "]");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            returnValue = this.invokeExtension(rag, methodToCall, edge);
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            logger.error((Object)("Dynamic invocation of the [" + extensionSegmentSet + "] extension failed."), (Throwable)ex);
            if (ex.getCause() != null) {
                Throwable cause = ex.getCause();
                logger.error((Object)("It would be smart to trap this this exception within the extension and supply a good response to the user:" + cause.getMessage()), cause);
            }
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        if (!(returnValue instanceof ExtensionResponse)) {
            logger.error((Object)("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse."));
            JSONObject error = this.generateErrorObject("The [" + extensionSegmentSet + "] extension does not return an ExtensionResponse.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        ExtensionResponse extResponse = (ExtensionResponse)returnValue;
        if (extResponse.isErrorResponse()) {
            logger.warn((Object)("The [" + extensionSegmentSet + "] extension raised an error response."));
            if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
                rag.tryRollback();
            }
            throw new WebApplicationException(Response.fromResponse((Response)extResponse.getJerseyResponse()).build());
        }
        if (methodToCall.getExtensionDefinition().autoCommitTransaction()) {
            rag.tryCommit();
        }
        String mediaType = "application/json";
        if (methodToCall != null) {
            mediaType = methodToCall.getExtensionDefinition().produces();
            extResponse = this.tryAppendRexsterAttributesIfJson(extResponse, methodToCall, mediaType);
        }
        return Response.fromResponse((Response)extResponse.getJerseyResponse()).type(mediaType).build();
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postNullEdgeConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, null, false, v);
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postNullEdgeConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, null, true, v);
    }

    @POST
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postNullEdgeConsumesUri(@Context Request request, @PathParam(value="graphname") String graphName) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, null, true, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, id, false, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, id, true, v);
    }

    @POST
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.post", absolute=true)
    public Response postEdgeConsumesUri(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.postEdge(graphName, id, true, v);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response postEdge(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id, boolean parseTypes, Variant variant) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        JSONObject theRequestObject = this.getRequestObject();
        MediaType produces = variant.getMediaType();
        boolean showTypes = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE);
        boolean showHypermedia = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE) || produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_JSON_TYPE);
        String inV = null;
        Object temp = theRequestObject.opt("_inV");
        if (null != temp) {
            inV = temp.toString();
        }
        String outV = null;
        temp = theRequestObject.opt("_outV");
        if (null != temp) {
            outV = temp.toString();
        }
        String label = null;
        temp = theRequestObject.opt("_label");
        if (null != temp) {
            label = temp.toString();
        }
        try {
            Edge edge;
            block15: {
                Edge edge2 = edge = id == null ? null : graph.getEdge((Object)id);
                if (null == edge && null != outV && null != inV && null != label) {
                    Vertex out = graph.getVertex((Object)outV);
                    Vertex in = graph.getVertex((Object)inV);
                    if (null != out && null != in) {
                        edge = graph.addEdge((Object)id, out, in, label);
                        break block15;
                    } else {
                        JSONObject error = this.generateErrorObjectJsonFail(new Exception("One or both of the vertices for the edge does not exist in the graph."));
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error).build());
                    }
                }
                if (edge != null && !RequestObjectHelper.hasElementProperties((JSONObject)theRequestObject)) {
                    JSONObject error = this.generateErrorObjectJsonFail(new Exception("Edge with id " + id + " already exists"));
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error).build());
                }
            }
            try {
                JSONArray extensionsList;
                if (edge == null) {
                    JSONObject error = this.generateErrorObjectJsonFail(new Exception("Edge cannot be found or created.  Please check the format of the request."));
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
                }
                Iterator keys = theRequestObject.keys();
                while (keys.hasNext()) {
                    String key = keys.next().toString();
                    if (key.startsWith("_")) continue;
                    edge.setProperty(key, ElementHelper.getTypedPropertyValue((Object)theRequestObject.get(key), (boolean)parseTypes));
                }
                GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
                Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
                JSONObject elementJson = GraphSONUtility.jsonFromElement((Element)edge, (Set)returnKeys, (GraphSONMode)mode);
                rag.tryCommit();
                elementJson.put("_id", edge.getId());
                this.resultObject.put("results", (Object)elementJson);
                if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.EDGE, this.getUriPath())) != null) {
                    this.resultObject.put("extensions", (Object)extensionsList);
                }
                this.resultObject.put("queryTime", this.sh.stopWatch());
                return Response.ok((Object)this.resultObject).build();
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            rag.tryRollback();
            JSONObject error = this.generateErrorObject("Transaction failed on POST of edge.", ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/json", "application/vnd.rexster-v1+json"})
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeConsumesJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putEdge(graphName, id, false, v);
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Consumes(value={"application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeConsumesTypedJson(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id, JSONObject json) {
        this.setRequestObject(json);
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putEdge(graphName, id, true, v);
    }

    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.put", absolute=true)
    public Response putEdgeOnUri(@Context Request request, @PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        Variant v = request.selectVariant(this.producesVariantList);
        return this.putEdge(graphName, id, true, v);
    }

    private Response putEdge(String graphName, String id, boolean parseTypes, Variant variant) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        MediaType produces = variant.getMediaType();
        boolean showTypes = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE);
        boolean showHypermedia = produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE) || produces.equals((Object)RexsterMediaType.APPLICATION_REXSTER_JSON_TYPE);
        try {
            JSONArray extensionsList;
            final Edge edge = graph.getEdge((Object)id);
            if (edge == null) {
                String msg = "Edge with id [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            com.tinkerpop.blueprints.util.ElementHelper.removeProperties((Iterable)new ArrayList<Element>(){
                {
                    this.add(edge);
                }
            });
            JSONObject theRequestObject = this.getRequestObject();
            GraphSONMode mode = showTypes ? GraphSONMode.EXTENDED : GraphSONMode.NORMAL;
            Set returnKeys = RequestObjectHelper.getReturnKeys((JSONObject)theRequestObject);
            Iterator keys = theRequestObject.keys();
            while (keys.hasNext()) {
                String key = keys.next().toString();
                if (key.startsWith("_")) continue;
                edge.setProperty(key, ElementHelper.getTypedPropertyValue((Object)theRequestObject.get(key), (boolean)parseTypes));
            }
            JSONObject elementJson = GraphSONUtility.jsonFromElement((Element)edge, (Set)returnKeys, (GraphSONMode)mode);
            rag.tryCommit();
            elementJson.put("_id", edge.getId());
            this.resultObject.put("results", (Object)elementJson);
            if (showHypermedia && (extensionsList = rag.getExtensionHypermedia(ExtensionPoint.EDGE, this.getUriPath())) != null) {
                this.resultObject.put("extensions", (Object)extensionsList);
            }
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            rag.tryRollback();
            logger.error((Object)ex);
            JSONObject error = this.generateErrorObject(ex.getMessage(), ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/vnd.rexster-v1+json", "application/vnd.rexster-typed-v1+json"})
    @Timed(name="http.rest.edges.object.delete", absolute=true)
    public Response deleteEdge(@PathParam(value="graphname") String graphName, @PathParam(value="id") String id) {
        RexsterApplicationGraph rag = this.getRexsterApplicationGraph(graphName);
        Graph graph = rag.getGraph();
        try {
            List<String> keys = this.getNonRexsterRequestKeys();
            Edge edge = graph.getEdge((Object)id);
            if (null != edge) {
                if (keys.size() > 0) {
                    for (String key : keys) {
                        edge.removeProperty(key);
                    }
                } else {
                    graph.removeEdge(edge);
                }
            } else {
                String msg = "Edge with id [" + id + "] cannot be found.";
                logger.info((Object)msg);
                JSONObject error = this.generateErrorObject(msg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)error).build());
            }
            rag.tryCommit();
            this.resultObject.put("queryTime", this.sh.stopWatch());
        }
        catch (JSONException ex) {
            logger.error((Object)ex);
            rag.tryRollback();
            JSONObject error = this.generateErrorObjectJsonFail(ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        catch (WebApplicationException wae) {
            rag.tryRollback();
            throw wae;
        }
        catch (Exception ex) {
            rag.tryRollback();
            JSONObject error = this.generateErrorObject("Transaction failed on DELETE of edge.", ex);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
        return Response.ok((Object)this.resultObject).build();
    }
}

