/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster;

import com.tinkerpop.rexster.RexsterMediaType;
import com.tinkerpop.rexster.extension.HttpMethod;
import com.tinkerpop.rexster.server.RexsterApplication;
import com.tinkerpop.rexster.util.StatisticsHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public abstract class BaseResource {
    private static Logger logger = Logger.getLogger(BaseResource.class);
    protected final List<Variant> producesVariantList = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.APPLICATION_JSON_TYPE, RexsterMediaType.APPLICATION_REXSTER_JSON_TYPE, RexsterMediaType.APPLICATION_REXSTER_TYPED_JSON_TYPE}).add().build();
    protected final StatisticsHelper sh = new StatisticsHelper();
    private JSONObject requestObject = null;
    private JSONObject requestObjectFlat = null;
    protected JSONObject resultObject = new JSONObject();
    @Context
    private RexsterApplication rexsterApplication;
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected ServletContext servletContext;
    @Context
    protected SecurityContext securityContext;

    public BaseResource(RexsterApplication rexsterApplication) {
        if (rexsterApplication != null) {
            this.rexsterApplication = rexsterApplication;
        }
        this.sh.stopWatch();
        try {
            this.resultObject.put("version", (Object)"2.5.0");
        }
        catch (JSONException ex) {
            JSONObject error = this.generateErrorObject(ex.getMessage());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
        }
    }

    public JSONObject generateErrorObject(String message) {
        return this.generateErrorObject(message, null);
    }

    public JSONObject generateErrorObjectJsonFail(Throwable source) {
        return this.generateErrorObject("An error occurred while generating the response object", source);
    }

    public JSONObject generateErrorObject(String message, Throwable source) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("message", message);
        if (source != null) {
            m.put("error", source.getMessage());
        }
        return new JSONObject(m);
    }

    protected RexsterApplication getRexsterApplication() {
        return this.rexsterApplication;
    }

    protected String getUriPath() {
        String baseUri = "";
        if (this.uriInfo != null && !(baseUri = this.uriInfo.getAbsolutePath().toString()).endsWith("/")) {
            baseUri = baseUri + "/";
        }
        return baseUri;
    }

    protected void setRequestObject(JSONObject jsonObject) {
        this.requestObject = jsonObject;
        this.requestObjectFlat = jsonObject;
    }

    protected void setRequestObject(MultivaluedMap<String, String> formData) {
        HashMap m = new HashMap();
        for (Map.Entry entry : formData.entrySet()) {
            m.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        this.requestObject = new JSONObject(m);
        this.requestObjectFlat = new JSONObject(m);
    }

    public JSONObject getRequestObject() {
        return this.getRequestObject(true);
    }

    public JSONObject getRequestObjectFlat() {
        return this.getRequestObject(false);
    }

    public JSONObject getRequestObject(boolean parseToJson) {
        if (this.requestObject == null) {
            try {
                this.requestObject = new JSONObject();
                this.requestObjectFlat = new JSONObject();
                if (this.httpServletRequest != null && this.httpServletRequest.getParameterNames().hasMoreElements()) {
                    Map queryParameters = this.httpServletRequest.getParameterMap();
                    this.buildRequestObject(queryParameters);
                }
            }
            catch (JSONException ex) {
                logger.error((Object)ex);
                JSONObject error = this.generateErrorObjectJsonFail(ex);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).build());
            }
        }
        if (parseToJson) {
            return this.requestObject;
        }
        return this.requestObjectFlat;
    }

    private void buildRequestObject(Map queryParameters) throws JSONException {
        HashMap<String, String> flatMap = new HashMap<String, String>();
        for (String key : queryParameters.keySet()) {
            String rawValue;
            String[] keys = key.split("\\.");
            JSONObject embeddedObject = this.requestObject;
            for (int i = 0; i < keys.length - 1; ++i) {
                JSONObject tempEmbeddedObject = (JSONObject)embeddedObject.opt(keys[i]);
                if (null == tempEmbeddedObject) {
                    tempEmbeddedObject = new JSONObject();
                    embeddedObject.put(keys[i], (Object)tempEmbeddedObject);
                }
                embeddedObject = tempEmbeddedObject;
            }
            Object val = queryParameters.get(key);
            if (val instanceof String) {
                rawValue = (String)val;
            } else {
                String[] values = (String[])val;
                rawValue = values[0];
            }
            flatMap.put(key, rawValue);
            try {
                if (rawValue.startsWith("[") && rawValue.endsWith("]")) {
                    rawValue = rawValue.substring(1, rawValue.length() - 1);
                    JSONArray array = new JSONArray();
                    for (String value : rawValue.split(",")) {
                        array.put((Object)value.trim());
                    }
                    embeddedObject.put(keys[keys.length - 1], (Object)array);
                    continue;
                }
                JSONObject parsedValue = new JSONObject(rawValue);
                embeddedObject.put(keys[keys.length - 1], (Object)parsedValue);
            }
            catch (JSONException e) {
                embeddedObject.put(keys[keys.length - 1], (Object)rawValue);
            }
        }
        this.requestObjectFlat = new JSONObject(flatMap);
    }

    protected JSONObject getNonRexsterRequest() throws JSONException {
        JSONObject object = new JSONObject();
        Iterator keys = this.getRequestObject().keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (key.equals("rexster")) continue;
            object.put(key, this.getRequestObject().opt(key));
        }
        return object;
    }

    protected List<String> getNonRexsterRequestKeys() throws JSONException {
        ArrayList<String> keys = new ArrayList<String>();
        JSONObject request = this.getNonRexsterRequest();
        if (request.length() > 0) {
            Iterator itty = request.keys();
            while (itty.hasNext()) {
                keys.add((String)itty.next());
            }
        }
        return keys;
    }

    protected String getTimeAlive() {
        long timeMillis = System.currentTimeMillis() - this.rexsterApplication.getStartTime();
        long timeSeconds = timeMillis / 1000L;
        long timeMinutes = timeSeconds / 60L;
        long timeHours = timeMinutes / 60L;
        long timeDays = timeHours / 24L;
        String seconds = Integer.toString((int)(timeSeconds % 60L));
        String minutes = Integer.toString((int)(timeMinutes % 60L));
        String hours = Integer.toString((int)timeHours % 24);
        String days = Integer.toString((int)timeDays);
        for (int i = 0; i < 2; ++i) {
            if (seconds.length() < 2) {
                seconds = "0" + seconds;
            }
            if (minutes.length() < 2) {
                minutes = "0" + minutes;
            }
            if (hours.length() >= 2) continue;
            hours = "0" + hours;
        }
        return days + "[d]:" + hours + "[h]:" + minutes + "[m]:" + seconds + "[s]";
    }

    protected Response buildOptionsResponse() {
        return this.buildOptionsResponse(HttpMethod.DELETE.toString(), HttpMethod.GET.toString(), HttpMethod.POST.toString(), HttpMethod.PUT.toString());
    }

    protected Response buildOptionsResponse(String ... methods) {
        String requestHeaders = this.httpServletRequest.getHeader("Access-Control-Request-Headers");
        String allowHeaders = requestHeaders == null ? "*" : requestHeaders;
        return Response.ok().header("Access-Control-Allow-Methods", (Object)("OPTIONS," + StringUtils.join((Object[])methods, (String)","))).header("Access-Control-Allow-Headers", (Object)allowHeaders).header("Access-Control-Max-Age", (Object)"1728000").build();
    }
}

