/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.base.Predicate;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Iterators2;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.BytesRefHash;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.bytes.BytesValuesSource;

public class StringTermsAggregator
extends BucketsAggregator {
    private final ValuesSource valuesSource;
    private final InternalOrder order;
    private final int requiredSize;
    private final int shardSize;
    private final long minDocCount;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude includeExclude;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, InternalOrder order, int requiredSize, int shardSize, long minDocCount, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, estimatedBucketCount, aggregationContext, parent);
        this.valuesSource = valuesSource;
        this.order = InternalOrder.validate(order, this);
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.minDocCount = minDocCount;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(estimatedBucketCount, aggregationContext.pageCacheRecycler());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        BytesValues values = this.valuesSource.bytesValues();
        int valuesCount = values.setDocument(doc);
        for (int i = 0; i < valuesCount; ++i) {
            BytesRef bytes = values.nextValue();
            if (this.includeExclude != null && !this.includeExclude.accept(bytes)) continue;
            int hash = values.currentValueHash();
            assert (hash == bytes.hashCode());
            long bucketOrdinal = this.bucketOrds.add(bytes, hash);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
            }
            this.collectBucket(doc, bucketOrdinal);
        }
    }

    private static Iterator<BytesRef> terms(final BytesValues.WithOrdinals bytesValues, boolean reverse) {
        final Ordinals.Docs ordinals = bytesValues.ordinals();
        if (reverse) {
            return new UnmodifiableIterator<BytesRef>(){
                long i;
                {
                    this.i = ordinals.getMaxOrd() - 1L;
                }

                @Override
                public boolean hasNext() {
                    return this.i >= 1L;
                }

                @Override
                public BytesRef next() {
                    bytesValues.getValueByOrd(this.i--);
                    return bytesValues.copyShared();
                }
            };
        }
        return new UnmodifiableIterator<BytesRef>(){
            long i = 1L;

            @Override
            public boolean hasNext() {
                return this.i < ordinals.getMaxOrd();
            }

            @Override
            public BytesRef next() {
                bytesValues.getValueByOrd(this.i++);
                return bytesValues.copyShared();
            }
        };
    }

    @Override
    public StringTerms buildAggregation(long owningBucketOrdinal) {
        assert (owningBucketOrdinal == 0L);
        if (this.minDocCount == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.requiredSize)) {
            ArrayList<BytesValues.WithOrdinals> valuesWithOrdinals = Lists.newArrayList();
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                BytesValues values = this.valuesSource.bytesValues();
                if (values instanceof BytesValues.WithOrdinals) {
                    valuesWithOrdinals.add((BytesValues.WithOrdinals)values);
                    continue;
                }
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    int valueCount = values.setDocument(docId);
                    for (int i = 0; i < valueCount; ++i) {
                        BytesRef term = values.nextValue();
                        if (this.includeExclude != null && !this.includeExclude.accept(term)) continue;
                        this.bucketOrds.add(term, values.currentValueHash());
                    }
                }
            }
            if (valuesWithOrdinals.size() > 0) {
                boolean reverse = this.order == InternalOrder.TERM_DESC;
                Comparator comparator = BytesRef.getUTF8SortedAsUnicodeComparator();
                if (reverse) {
                    comparator = Collections.reverseOrder(comparator);
                }
                Iterator[] iterators = new Iterator[valuesWithOrdinals.size()];
                for (int i = 0; i < valuesWithOrdinals.size(); ++i) {
                    iterators[i] = StringTermsAggregator.terms((BytesValues.WithOrdinals)valuesWithOrdinals.get(i), reverse);
                }
                Iterator terms = Iterators2.mergeSorted(Arrays.asList(iterators), comparator, true);
                if (this.includeExclude != null) {
                    terms = Iterators.filter(terms, new Predicate<BytesRef>(){

                        @Override
                        public boolean apply(BytesRef input) {
                            return StringTermsAggregator.this.includeExclude.accept(input);
                        }
                    });
                }
                if (this.order == InternalOrder.COUNT_ASC) {
                    int added = 0;
                    while (added < this.shardSize && terms.hasNext()) {
                        if (this.bucketOrds.add((BytesRef)terms.next()) < 0L) continue;
                        ++added;
                    }
                } else if (this.order == InternalOrder.COUNT_DESC) {
                    while (this.bucketOrds.size() < (long)this.requiredSize && terms.hasNext()) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                } else if (this.order == InternalOrder.TERM_ASC || this.order == InternalOrder.TERM_DESC) {
                    for (int i = 0; i < this.requiredSize && terms.hasNext(); ++i) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                } else {
                    while (terms.hasNext()) {
                        this.bucketOrds.add((BytesRef)terms.next());
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        StringTerms.Bucket spare = null;
        int i = 0;
        while ((long)i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null);
            }
            this.bucketOrds.get(i, spare.termBytes);
            spare.docCount = this.bucketDocCount(i);
            spare.bucketOrd = i;
            spare = (StringTerms.Bucket)ordered.insertWithOverflow(spare);
            ++i;
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            StringTerms.Bucket bucket = (StringTerms.Bucket)ordered.pop();
            bucket.termBytes = BytesRef.deepCopyOf((BytesRef)bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return new StringTerms(this.name, this.order, this.requiredSize, this.minDocCount, Arrays.asList(list));
    }

    @Override
    public StringTerms buildEmptyAggregation() {
        return new StringTerms(this.name, this.order, this.requiredSize, this.minDocCount, Collections.<InternalTerms.Bucket>emptyList());
    }

    @Override
    public void doRelease() {
        Releasables.release(this.bucketOrds);
    }

    public static class WithOrdinals
    extends StringTermsAggregator
    implements ReaderContextAware {
        private final BytesValuesSource.WithOrdinals valuesSource;
        private BytesValues.WithOrdinals bytesValues;
        private Ordinals.Docs ordinals;
        private LongArray ordinalToBucket;

        public WithOrdinals(String name, AggregatorFactories factories, BytesValuesSource.WithOrdinals valuesSource, long esitmatedBucketCount, InternalOrder order, int requiredSize, int shardSize, long minDocCount, AggregationContext aggregationContext, Aggregator parent) {
            super(name, factories, valuesSource, esitmatedBucketCount, order, requiredSize, shardSize, minDocCount, null, aggregationContext, parent);
            this.valuesSource = valuesSource;
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            this.bytesValues = this.valuesSource.bytesValues();
            this.ordinals = this.bytesValues.ordinals();
            long maxOrd = this.ordinals.getMaxOrd();
            if (this.ordinalToBucket == null || this.ordinalToBucket.size() < maxOrd) {
                if (this.ordinalToBucket != null) {
                    this.ordinalToBucket.release();
                }
                this.ordinalToBucket = BigArrays.newLongArray(BigArrays.overSize(maxOrd), this.context().pageCacheRecycler(), false);
            }
            this.ordinalToBucket.fill(0L, maxOrd, -1L);
        }

        @Override
        public void collect(int doc, long owningBucketOrdinal) throws IOException {
            assert (owningBucketOrdinal == 0L) : "this is a per_bucket aggregator";
            int valuesCount = this.ordinals.setDocument(doc);
            for (int i = 0; i < valuesCount; ++i) {
                long ord = this.ordinals.nextOrd();
                long bucketOrd = this.ordinalToBucket.get(ord);
                if (bucketOrd < 0L) {
                    BytesRef bytes = this.bytesValues.getValueByOrd(ord);
                    int hash = this.bytesValues.currentValueHash();
                    assert (hash == bytes.hashCode());
                    bucketOrd = this.bucketOrds.add(bytes, hash);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                    }
                    this.ordinalToBucket.set(ord, bucketOrd);
                }
                this.collectBucket(doc, bucketOrd);
            }
        }

        @Override
        public void doRelease() {
            Releasables.release(this.bucketOrds, this.ordinalToBucket);
        }
    }
}

