/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Comparator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.primitives.Longs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;

class InternalOrder
extends Terms.Order {
    public static final InternalOrder COUNT_DESC = new InternalOrder(1, "_count", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            int cmp = -Longs.compare(o1.getDocCount(), o2.getDocCount());
            if (cmp == 0) {
                cmp = o1.compareTerm(o2);
            }
            return cmp;
        }
    });
    public static final InternalOrder COUNT_ASC = new InternalOrder(2, "_count", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            int cmp = Longs.compare(o1.getDocCount(), o2.getDocCount());
            if (cmp == 0) {
                cmp = o1.compareTerm(o2);
            }
            return cmp;
        }
    });
    public static final InternalOrder TERM_DESC = new InternalOrder(3, "_term", false, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return -o1.compareTerm(o2);
        }
    });
    public static final InternalOrder TERM_ASC = new InternalOrder(4, "_term", true, new Comparator<Terms.Bucket>(){

        @Override
        public int compare(Terms.Bucket o1, Terms.Bucket o2) {
            return o1.compareTerm(o2);
        }
    });
    final byte id;
    final String key;
    final boolean asc;
    protected final Comparator<Terms.Bucket> comparator;

    InternalOrder(byte id, String key, boolean asc, Comparator<Terms.Bucket> comparator) {
        this.id = id;
        this.key = key;
        this.asc = asc;
        this.comparator = comparator;
    }

    byte id() {
        return this.id;
    }

    String key() {
        return this.key;
    }

    boolean asc() {
        return this.asc;
    }

    @Override
    protected Comparator<Terms.Bucket> comparator(Aggregator aggregator) {
        return this.comparator;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(this.key, this.asc ? "asc" : "desc").endObject();
    }

    public static InternalOrder validate(InternalOrder order, Aggregator termsAggregator) {
        if (!(order instanceof Aggregation)) {
            return order;
        }
        String aggName = ((Aggregation)order).aggName();
        Aggregator[] subAggregators = termsAggregator.subAggregators();
        for (int i = 0; i < subAggregators.length; ++i) {
            Aggregator aggregator = subAggregators[i];
            if (!aggregator.name().equals(aggName)) continue;
            if (!(aggregator instanceof MetricsAggregator)) {
                throw new AggregationExecutionException("terms aggregation [" + termsAggregator.name() + "] is configured to order by sub-aggregation [" + aggName + "] which is is not a metrics aggregation. Terms aggregation order can only refer to metrics aggregations");
            }
            if (aggregator instanceof MetricsAggregator.MultiValue) {
                String valueName = ((Aggregation)order).metricName();
                if (valueName == null) {
                    throw new AggregationExecutionException("terms aggregation [" + termsAggregator.name() + "] is configured with a sub-aggregation order [" + aggName + "] which is a multi-valued aggregation, yet no metric name was specified");
                }
                if (!((MetricsAggregator.MultiValue)aggregator).hasMetric(valueName)) {
                    throw new AggregationExecutionException("terms aggregation [" + termsAggregator.name() + "] is configured with a sub-aggregation order [" + aggName + "] and value [" + valueName + "] yet the referred sub aggregator holds no metric that goes by this name");
                }
                return order;
            }
            return order;
        }
        throw new AggregationExecutionException("terms aggregation [" + termsAggregator.name() + "] is configured with a sub-aggregation order [" + aggName + "] but no sub aggregation with this name is configured");
    }

    public static class Streams {
        public static void writeOrder(InternalOrder order, StreamOutput out) throws IOException {
            out.writeByte(order.id());
            if (order instanceof Aggregation) {
                out.writeBoolean(((MultiBucketsAggregation.Bucket.SubAggregationComparator)order.comparator).asc());
                out.writeString(((MultiBucketsAggregation.Bucket.SubAggregationComparator)order.comparator).aggName());
                boolean hasValueName = ((MultiBucketsAggregation.Bucket.SubAggregationComparator)order.comparator).valueName() != null;
                out.writeBoolean(hasValueName);
                if (hasValueName) {
                    out.writeString(((MultiBucketsAggregation.Bucket.SubAggregationComparator)order.comparator).valueName());
                }
            }
        }

        public static InternalOrder readOrder(StreamInput in) throws IOException {
            byte id = in.readByte();
            switch (id) {
                case 1: {
                    return COUNT_DESC;
                }
                case 2: {
                    return COUNT_ASC;
                }
                case 3: {
                    return TERM_DESC;
                }
                case 4: {
                    return TERM_ASC;
                }
                case 0: {
                    boolean asc = in.readBoolean();
                    String key = in.readString();
                    if (in.readBoolean()) {
                        return new Aggregation(key, in.readString(), asc);
                    }
                    return new Aggregation(key, asc);
                }
            }
            throw new RuntimeException("unknown terms order");
        }
    }

    static class Aggregation
    extends InternalOrder {
        static final byte ID = 0;

        Aggregation(String key, boolean asc) {
            super((byte)0, key, asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<Terms.Bucket>(key, asc));
        }

        Aggregation(String aggName, String metricName, boolean asc) {
            super((byte)0, Aggregation.key(aggName, metricName), asc, new MultiBucketsAggregation.Bucket.SubAggregationComparator<Terms.Bucket>(aggName, metricName, asc));
        }

        String aggName() {
            int index = this.key.indexOf(46);
            return index < 0 ? this.key : this.key.substring(0, index);
        }

        String metricName() {
            int index = this.key.indexOf(46);
            return index < 0 ? null : this.key.substring(index + 1, this.key.length());
        }

        private static String key(String aggName, String valueName) {
            return valueName == null ? aggName : aggName + "." + valueName;
        }

        @Override
        protected Comparator<Terms.Bucket> comparator(Aggregator termsAggregator) {
            if (termsAggregator == null) {
                return this.comparator;
            }
            final Aggregator aggregator = this.subAggregator(this.aggName(), termsAggregator);
            assert (aggregator != null && aggregator instanceof MetricsAggregator) : "this should be picked up before the aggregation is executed";
            if (aggregator instanceof MetricsAggregator.MultiValue) {
                final String valueName = this.metricName();
                assert (valueName != null) : "this should be picked up before the aggregation is executed";
                return new Comparator<Terms.Bucket>(){

                    @Override
                    public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                        double v1 = ((MetricsAggregator.MultiValue)aggregator).metric(valueName, ((InternalTerms.Bucket)o1).bucketOrd);
                        double v2 = ((MetricsAggregator.MultiValue)aggregator).metric(valueName, ((InternalTerms.Bucket)o2).bucketOrd);
                        if (v1 == Double.NaN) {
                            return Aggregation.this.asc ? 1 : -1;
                        }
                        return Aggregation.this.asc ? Double.compare(v1, v2) : Double.compare(v2, v1);
                    }
                };
            }
            return new Comparator<Terms.Bucket>(){

                @Override
                public int compare(Terms.Bucket o1, Terms.Bucket o2) {
                    double v1 = ((MetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o1).bucketOrd);
                    double v2 = ((MetricsAggregator.SingleValue)aggregator).metric(((InternalTerms.Bucket)o2).bucketOrd);
                    if (v1 == Double.NaN) {
                        return Aggregation.this.asc ? 1 : -1;
                    }
                    return Aggregation.this.asc ? Double.compare(v1, v2) : Double.compare(v2, v1);
                }
            };
        }

        private Aggregator subAggregator(String aggName, Aggregator termsAggregator) {
            Aggregator[] subAggregators = termsAggregator.subAggregators();
            for (int i = 0; i < subAggregators.length; ++i) {
                if (!subAggregators[i].name().equals(aggName)) continue;
                return subAggregators[i];
            }
            return null;
        }
    }
}

