/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.XContentThrowableRestResponse;

public abstract class AbstractRestResponseActionListener<T extends ActionResponse>
implements ActionListener<T> {
    protected final RestChannel channel;
    protected final RestRequest request;
    protected final ESLogger logger;

    public AbstractRestResponseActionListener(RestRequest request, RestChannel channel, ESLogger logger) {
        this.request = request;
        this.channel = channel;
        this.logger = logger;
    }

    @Override
    public abstract void onResponse(T var1);

    @Override
    public void onFailure(Throwable e) {
        try {
            this.channel.sendResponse(new XContentThrowableRestResponse(this.request, e));
        }
        catch (IOException e1) {
            this.logger.error("Failed to send failure response", e1, new Object[0]);
        }
    }
}

