/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.repositories.RepositoryModule;
import org.elasticsearch.repositories.RepositoryName;
import org.elasticsearch.repositories.RepositoryNameModule;
import org.elasticsearch.repositories.RepositoryTypesRegistry;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.snapshots.SnapshotsService;

public class RepositoriesService
extends AbstractComponent
implements ClusterStateListener {
    private final RepositoryTypesRegistry typesRegistry;
    private final Injector injector;
    private final ClusterService clusterService;
    private volatile ImmutableMap<String, RepositoryHolder> repositories = ImmutableMap.of();

    @Inject
    public RepositoriesService(Settings settings, ClusterService clusterService, RepositoryTypesRegistry typesRegistry, Injector injector) {
        super(settings);
        this.typesRegistry = typesRegistry;
        this.injector = injector;
        this.clusterService = clusterService;
        if (DiscoveryNode.dataNode(settings) || DiscoveryNode.masterNode(settings)) {
            clusterService.add(this);
        }
    }

    public void registerRepository(final RegisterRepositoryRequest request, final ActionListener<RegisterRepositoryResponse> listener) {
        final RepositoryMetaData newRepositoryMetaData = new RepositoryMetaData(request.name, request.type, request.settings);
        this.clusterService.submitStateUpdateTask(request.cause, new AckedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesService.this.ensureRepositoryNotInUse(currentState, request.name);
                if (!RepositoriesService.this.registerRepository(newRepositoryMetaData)) {
                    return currentState;
                }
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
                if (repositories == null) {
                    RepositoriesService.this.logger.info("put repository [{}]", request.name);
                    repositories = new RepositoriesMetaData(new RepositoryMetaData(request.name, request.type, request.settings));
                } else {
                    boolean found = false;
                    ArrayList<RepositoryMetaData> repositoriesMetaData = new ArrayList<RepositoryMetaData>(repositories.repositories().size() + 1);
                    for (RepositoryMetaData repositoryMetaData : repositories.repositories()) {
                        if (repositoryMetaData.name().equals(newRepositoryMetaData.name())) {
                            found = true;
                            repositoriesMetaData.add(newRepositoryMetaData);
                            continue;
                        }
                        repositoriesMetaData.add(repositoryMetaData);
                    }
                    if (!found) {
                        RepositoriesService.this.logger.info("put repository [{}]", request.name);
                        repositoriesMetaData.add(new RepositoryMetaData(request.name, request.type, request.settings));
                    } else {
                        RepositoriesService.this.logger.info("update repository [{}]", request.name);
                    }
                    repositories = new RepositoriesMetaData(repositoriesMetaData.toArray(new RepositoryMetaData[repositoriesMetaData.size()]));
                }
                mdBuilder.putCustom("repositories", repositories);
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                RepositoriesService.this.logger.warn("failed to create repository [{}]", t, request.name);
                listener.onFailure(t);
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.masterNode();
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new RegisterRepositoryResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new RegisterRepositoryResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    public void unregisterRepository(final UnregisterRepositoryRequest request, final ActionListener<UnregisterRepositoryResponse> listener) {
        this.clusterService.submitStateUpdateTask(request.cause, new AckedClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesService.this.ensureRepositoryNotInUse(currentState, request.name);
                MetaData metaData = currentState.metaData();
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                RepositoriesMetaData repositories = (RepositoriesMetaData)metaData.custom("repositories");
                if (repositories != null && repositories.repositories().size() > 0) {
                    ArrayList<RepositoryMetaData> repositoriesMetaData = new ArrayList<RepositoryMetaData>(repositories.repositories().size());
                    boolean changed = false;
                    for (RepositoryMetaData repositoryMetaData : repositories.repositories()) {
                        if (Regex.simpleMatch(request.name, repositoryMetaData.name())) {
                            RepositoriesService.this.logger.info("delete repository [{}]", repositoryMetaData.name());
                            changed = true;
                            continue;
                        }
                        repositoriesMetaData.add(repositoryMetaData);
                    }
                    if (changed) {
                        repositories = new RepositoriesMetaData(repositoriesMetaData.toArray(new RepositoryMetaData[repositoriesMetaData.size()]));
                        mdBuilder.putCustom("repositories", repositories);
                        return ClusterState.builder(currentState).metaData(mdBuilder).build();
                    }
                }
                throw new RepositoryMissingException(request.name);
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return discoveryNode.masterNode();
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new UnregisterRepositoryResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new UnregisterRepositoryResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            RepositoriesMetaData oldMetaData = (RepositoriesMetaData)event.previousState().getMetaData().custom("repositories");
            RepositoriesMetaData newMetaData = (RepositoriesMetaData)event.state().getMetaData().custom("repositories");
            if (oldMetaData == null && newMetaData == null || oldMetaData != null && oldMetaData.equals(newMetaData)) {
                return;
            }
            HashMap survivors = Maps.newHashMap();
            for (Map.Entry entry : this.repositories.entrySet()) {
                if (newMetaData == null || newMetaData.repository((String)entry.getKey()) == null) {
                    this.closeRepository((String)entry.getKey(), (RepositoryHolder)entry.getValue());
                    continue;
                }
                survivors.put(entry.getKey(), entry.getValue());
            }
            ImmutableMap.Builder<String, RepositoryHolder> builder = ImmutableMap.builder();
            if (newMetaData != null) {
                for (RepositoryMetaData repositoryMetaData : newMetaData.repositories()) {
                    RepositoryHolder holder = (RepositoryHolder)survivors.get(repositoryMetaData.name());
                    if (holder != null) {
                        if (!holder.type.equals(repositoryMetaData.type()) || !holder.settings.equals(repositoryMetaData.settings())) {
                            this.closeRepository(repositoryMetaData.name(), holder);
                            holder = this.createRepositoryHolder(repositoryMetaData);
                        }
                    } else {
                        holder = this.createRepositoryHolder(repositoryMetaData);
                    }
                    if (holder == null) continue;
                    builder.put(repositoryMetaData.name(), holder);
                }
            }
            this.repositories = builder.build();
        }
        catch (Throwable ex) {
            this.logger.warn("failure updating cluster state ", ex, new Object[0]);
        }
    }

    public Repository repository(String repository) {
        RepositoryHolder holder = this.repositories.get(repository);
        if (holder != null) {
            return holder.repository;
        }
        throw new RepositoryMissingException(repository);
    }

    public IndexShardRepository indexShardRepository(String repository) {
        RepositoryHolder holder = this.repositories.get(repository);
        if (holder != null) {
            return holder.indexShardRepository;
        }
        throw new RepositoryMissingException(repository);
    }

    private boolean registerRepository(RepositoryMetaData repositoryMetaData) {
        RepositoryHolder previous = this.repositories.get(repositoryMetaData.name());
        if (previous != null && !previous.type.equals(repositoryMetaData.type()) && previous.settings.equals(repositoryMetaData.settings())) {
            return false;
        }
        RepositoryHolder holder = this.createRepositoryHolder(repositoryMetaData);
        if (previous != null) {
            this.closeRepository(repositoryMetaData.name(), previous);
        }
        HashMap<String, RepositoryHolder> newRepositories = Maps.newHashMap(this.repositories);
        newRepositories.put(repositoryMetaData.name(), holder);
        this.repositories = ImmutableMap.copyOf(newRepositories);
        return true;
    }

    private void closeRepository(String name, RepositoryHolder holder) {
        this.logger.debug("closing repository [{}][{}]", holder.type, name);
        if (holder.injector != null) {
            Injectors.close(holder.injector);
        }
        if (holder.repository != null) {
            holder.repository.close();
        }
    }

    private RepositoryHolder createRepositoryHolder(RepositoryMetaData repositoryMetaData) {
        this.logger.debug("creating repository [{}][{}]", repositoryMetaData.type(), repositoryMetaData.name());
        Injector repositoryInjector = null;
        try {
            ModulesBuilder modules = new ModulesBuilder();
            RepositoryName name = new RepositoryName(repositoryMetaData.type(), repositoryMetaData.name());
            modules.add((Module)new RepositoryNameModule(name));
            modules.add((Module)new RepositoryModule(name, repositoryMetaData.settings(), this.settings, this.typesRegistry));
            repositoryInjector = modules.createChildInjector(this.injector);
            Repository repository = repositoryInjector.getInstance(Repository.class);
            IndexShardRepository indexShardRepository = repositoryInjector.getInstance(IndexShardRepository.class);
            repository.start();
            return new RepositoryHolder(repositoryMetaData.type(), repositoryMetaData.settings(), repositoryInjector, repository, indexShardRepository);
        }
        catch (Throwable t) {
            if (repositoryInjector != null) {
                Injectors.close(repositoryInjector);
            }
            this.logger.warn("failed to create repository [{}][{}]", t, repositoryMetaData.type(), repositoryMetaData.name());
            throw new RepositoryException(repositoryMetaData.name(), "failed to create repository", t);
        }
    }

    private void ensureRepositoryNotInUse(ClusterState clusterState, String repository) {
        if (SnapshotsService.isRepositoryInUse(clusterState, repository) || RestoreService.isRepositoryInUse(clusterState, repository)) {
            throw new ElasticsearchIllegalStateException("trying to modify or unregister repository that is currently used ");
        }
    }

    public static class UnregisterRepositoryResponse
    extends ClusterStateUpdateResponse {
        UnregisterRepositoryResponse(boolean acknowledged) {
            super(acknowledged);
        }
    }

    public static class UnregisterRepositoryRequest
    extends ClusterStateUpdateRequest<UnregisterRepositoryRequest> {
        final String cause;
        final String name;

        public UnregisterRepositoryRequest(String cause, String name) {
            this.cause = cause;
            this.name = name;
        }
    }

    public static class RegisterRepositoryResponse
    extends ClusterStateUpdateResponse {
        RegisterRepositoryResponse(boolean acknowledged) {
            super(acknowledged);
        }
    }

    public static class RegisterRepositoryRequest
    extends ClusterStateUpdateRequest<RegisterRepositoryRequest> {
        final String cause;
        final String name;
        final String type;
        Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;

        public RegisterRepositoryRequest(String cause, String name, String type) {
            this.cause = cause;
            this.name = name;
            this.type = type;
        }

        public RegisterRepositoryRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }
    }

    private static class RepositoryHolder {
        private final String type;
        private final Settings settings;
        private final Injector injector;
        private final Repository repository;
        private final IndexShardRepository indexShardRepository;

        public RepositoryHolder(String type, Settings settings, Injector injector, Repository repository, IndexShardRepository indexShardRepository) {
            this.type = type;
            this.settings = settings;
            this.repository = repository;
            this.indexShardRepository = indexShardRepository;
            this.injector = injector;
        }
    }
}

