/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;

public class RecoveryStatus {
    final ShardId shardId;
    final long recoveryId;
    final InternalIndexShard indexShard;
    volatile Thread recoveryThread;
    private volatile boolean canceled;
    volatile boolean sentCanceledToSource;
    private volatile ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    ConcurrentMap<String, String> checksums = ConcurrentCollections.newConcurrentMap();
    final long startTime = System.currentTimeMillis();
    long time;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    long phase1TotalSize;
    long phase1ExistingTotalSize;
    volatile Stage stage = Stage.INIT;
    volatile long currentTranslogOperations = 0L;
    AtomicLong currentFilesSize = new AtomicLong();

    public RecoveryStatus(long recoveryId, InternalIndexShard indexShard) {
        this.recoveryId = recoveryId;
        this.indexShard = indexShard;
        this.shardId = indexShard.shardId();
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public long phase1TotalSize() {
        return this.phase1TotalSize;
    }

    public long phase1ExistingTotalSize() {
        return this.phase1ExistingTotalSize;
    }

    public Stage stage() {
        return this.stage;
    }

    public long currentTranslogOperations() {
        return this.currentTranslogOperations;
    }

    public long currentFilesSize() {
        return this.currentFilesSize.get();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public synchronized void cancel() {
        this.canceled = true;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (this.canceled || outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.get(key);
    }

    public synchronized Set<Map.Entry<String, IndexOutput>> cancleAndClearOpenIndexInputs() {
        this.cancel();
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        this.openIndexOutputs = null;
        if (outputs == null) {
            return null;
        }
        Set<Map.Entry<String, IndexOutput>> entrySet = outputs.entrySet();
        return entrySet;
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        if (outputs == null) {
            return null;
        }
        return (IndexOutput)outputs.remove(name);
    }

    public synchronized IndexOutput openAndPutIndexOutput(String key, String name, Store store) throws IOException {
        if (this.isCanceled()) {
            return null;
        }
        ConcurrentMap<String, IndexOutput> outputs = this.openIndexOutputs;
        IndexOutput indexOutput = store.createOutputRaw(name);
        outputs.put(key, indexOutput);
        return indexOutput;
    }

    public static enum Stage {
        INIT,
        INDEX,
        TRANSLOG,
        FINALIZE,
        DONE;

    }
}

