/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.store.StoreFileMetaData;

public class BlobStoreIndexShardSnapshot {
    private final String snapshot;
    private final long indexVersion;
    private final ImmutableList<FileInfo> indexFiles;

    public BlobStoreIndexShardSnapshot(String snapshot, long indexVersion, List<FileInfo> indexFiles) {
        assert (snapshot != null);
        assert (indexVersion >= 0L);
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.indexFiles = ImmutableList.copyOf(indexFiles);
    }

    public long indexVersion() {
        return this.indexVersion;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public ImmutableList<FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public static void toXContent(BlobStoreIndexShardSnapshot snapshot, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", snapshot.snapshot);
        builder.field("index-version", snapshot.indexVersion);
        builder.startArray("files");
        for (FileInfo fileInfo : snapshot.indexFiles) {
            FileInfo.toXContent(fileInfo, builder, params);
        }
        builder.endArray();
        builder.endObject();
    }

    public static BlobStoreIndexShardSnapshot fromXContent(XContentParser parser) throws IOException {
        String snapshot = null;
        long indexVersion = -1L;
        ArrayList<FileInfo> indexFiles = Lists.newArrayList();
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if ("name".equals(currentFieldName)) {
                            snapshot = parser.text();
                            continue;
                        }
                        if ("index-version".equals(currentFieldName)) {
                            indexVersion = parser.longValue();
                            continue;
                        }
                        throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            indexFiles.add(FileInfo.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                }
                throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
            }
        }
        return new BlobStoreIndexShardSnapshot(snapshot, indexVersion, ImmutableList.copyOf(indexFiles));
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public FileInfo findPhysicalIndexFile(String physicalName) {
        for (FileInfo file : this.indexFiles) {
            if (!file.physicalName().equals(physicalName)) continue;
            return file;
        }
        return null;
    }

    public FileInfo findNameFile(String name) {
        for (FileInfo file : this.indexFiles) {
            if (!file.name().equals(name)) continue;
            return file;
        }
        return null;
    }

    public static class FileInfo {
        private final String name;
        private final String physicalName;
        private final long length;
        private final String checksum;
        private final ByteSizeValue partSize;
        private final long partBytes;
        private final long numberOfParts;

        public FileInfo(String name, String physicalName, long length, ByteSizeValue partSize, String checksum) {
            this.name = name;
            this.physicalName = physicalName;
            this.length = length;
            this.checksum = checksum;
            long partBytes = Long.MAX_VALUE;
            if (partSize != null) {
                partBytes = partSize.bytes();
            }
            long totalLength = length;
            long numberOfParts = totalLength / partBytes;
            if (totalLength % partBytes > 0L) {
                ++numberOfParts;
            }
            if (numberOfParts == 0L) {
                ++numberOfParts;
            }
            this.numberOfParts = numberOfParts;
            this.partSize = partSize;
            this.partBytes = partBytes;
        }

        public String name() {
            return this.name;
        }

        public String partName(long part) {
            if (this.numberOfParts > 1L) {
                return this.name + ".part" + part;
            }
            return this.name;
        }

        public static String canonicalName(String blobName) {
            if (blobName.contains(".part")) {
                return blobName.substring(0, blobName.indexOf(".part"));
            }
            return blobName;
        }

        public String physicalName() {
            return this.physicalName;
        }

        public long length() {
            return this.length;
        }

        public ByteSizeValue partSize() {
            return this.partSize;
        }

        public long partBytes() {
            return this.partBytes;
        }

        public long numberOfParts() {
            return this.numberOfParts;
        }

        @Nullable
        public String checksum() {
            return this.checksum;
        }

        public boolean isSame(StoreFileMetaData md) {
            if (this.checksum == null || md.checksum() == null) {
                return false;
            }
            return this.length == md.length() && this.checksum.equals(md.checksum());
        }

        public static void toXContent(FileInfo file, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.NAME, file.name);
            builder.field(Fields.PHYSICAL_NAME, file.physicalName);
            builder.field(Fields.LENGTH, file.length);
            if (file.checksum != null) {
                builder.field(Fields.CHECKSUM, file.checksum);
            }
            if (file.partSize != null) {
                builder.field(Fields.PART_SIZE, file.partSize.bytes());
            }
            builder.endObject();
        }

        public static FileInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            String name = null;
            String physicalName = null;
            long length = -1L;
            String checksum = null;
            ByteSizeValue partSize = null;
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        String currentFieldName = parser.currentName();
                        token = parser.nextToken();
                        if (token.isValue()) {
                            if ("name".equals(currentFieldName)) {
                                name = parser.text();
                                continue;
                            }
                            if ("physical_name".equals(currentFieldName)) {
                                physicalName = parser.text();
                                continue;
                            }
                            if ("length".equals(currentFieldName)) {
                                length = parser.longValue();
                                continue;
                            }
                            if ("checksum".equals(currentFieldName)) {
                                checksum = parser.text();
                                continue;
                            }
                            if ("part_size".equals(currentFieldName)) {
                                partSize = new ByteSizeValue(parser.longValue());
                                continue;
                            }
                            throw new ElasticsearchParseException("unknown parameter [" + currentFieldName + "]");
                        }
                        throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                    }
                    throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                }
            }
            return new FileInfo(name, physicalName, length, partSize, checksum);
        }

        static final class Fields {
            static final XContentBuilderString NAME = new XContentBuilderString("name");
            static final XContentBuilderString PHYSICAL_NAME = new XContentBuilderString("physical_name");
            static final XContentBuilderString LENGTH = new XContentBuilderString("length");
            static final XContentBuilderString CHECKSUM = new XContentBuilderString("checksum");
            static final XContentBuilderString PART_SIZE = new XContentBuilderString("part_size");

            Fields() {
            }
        }
    }
}

