/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.ToParentBlockJoinQuery;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;

public class NestedQueryParser
implements QueryParser {
    public static final String NAME = "nested";
    static ThreadLocal<LateBindingParentFilter> parentFilterContext = new ThreadLocal();

    @Inject
    public NestedQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME, Strings.toCamelCase(NAME)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        Object query = null;
        boolean queryFound = false;
        Filter filter = null;
        boolean filterFound = false;
        float boost = 1.0f;
        String path = null;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        LateBindingParentFilter currentParentFilterContext = parentFilterContext.get();
        LateBindingParentFilter usAsParentFilter = new LateBindingParentFilter();
        parentFilterContext.set(usAsParentFilter);
        try {
            Filter childFilter;
            MapperService.SmartNameObjectMapper mapper;
            String sScoreMode;
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("query".equals(currentFieldName)) {
                        queryFound = true;
                        query = parseContext.parseInnerQuery();
                        continue;
                    }
                    if ("filter".equals(currentFieldName)) {
                        filterFound = true;
                        filter = parseContext.parseInnerFilter();
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "[nested] query does not support [" + currentFieldName + "]");
                }
                if (!token.isValue()) continue;
                if ("path".equals(currentFieldName)) {
                    path = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("_scope".equals(currentFieldName)) {
                    throw new QueryParsingException(parseContext.index(), "the [_scope] support in [nested] query has been removed, use nested filter as a facet_filter in the relevant facet");
                }
                if ("score_mode".equals(currentFieldName) || "scoreMode".equals(currentFieldName)) {
                    sScoreMode = parser.text();
                    if ("avg".equals(sScoreMode)) {
                        scoreMode = ScoreMode.Avg;
                        continue;
                    }
                    if ("max".equals(sScoreMode)) {
                        scoreMode = ScoreMode.Max;
                        continue;
                    }
                    if ("total".equals(sScoreMode) || "sum".equals(sScoreMode)) {
                        scoreMode = ScoreMode.Total;
                        continue;
                    }
                    if ("none".equals(sScoreMode)) {
                        scoreMode = ScoreMode.None;
                        continue;
                    }
                    throw new QueryParsingException(parseContext.index(), "illegal score_mode for nested query [" + sScoreMode + "]");
                }
                if ("_name".equals(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[nested] query does not support [" + currentFieldName + "]");
            }
            if (!queryFound && !filterFound) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires either 'query' or 'filter' field");
            }
            if (path == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] requires 'path' field");
            }
            if (query == null && filter == null) {
                sScoreMode = null;
                return sScoreMode;
            }
            if (filter != null) {
                query = new XConstantScoreQuery(filter);
            }
            if ((mapper = parseContext.smartObjectMapper(path)) == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            ObjectMapper objectMapper = mapper.mapper();
            if (objectMapper == null) {
                throw new QueryParsingException(parseContext.index(), "[nested] failed to find nested object under path [" + path + "]");
            }
            if (!objectMapper.nested().isNested()) {
                throw new QueryParsingException(parseContext.index(), "[nested] nested object under path [" + path + "] is not of nested type");
            }
            usAsParentFilter.filter = childFilter = parseContext.cacheFilter(objectMapper.nestedTypeFilter(), null);
            query = new XFilteredQuery((Query)query, childFilter);
            Filter parentFilter = currentParentFilterContext;
            if (parentFilter == null) {
                parentFilter = NonNestedDocsFilter.INSTANCE;
                parentFilter = parseContext.cacheFilter(parentFilter, null);
            }
            ToParentBlockJoinQuery joinQuery = new ToParentBlockJoinQuery((Query)query, parentFilter, scoreMode);
            joinQuery.setBoost(boost);
            if (queryName != null) {
                parseContext.addNamedQuery(queryName, (Query)joinQuery);
            }
            ToParentBlockJoinQuery toParentBlockJoinQuery = joinQuery;
            return toParentBlockJoinQuery;
        }
        finally {
            parentFilterContext.set(currentParentFilterContext);
        }
    }

    static class LateBindingParentFilter
    extends Filter {
        Filter filter;

        LateBindingParentFilter() {
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            return this.filter.equals(obj);
        }

        public String toString() {
            return this.filter.toString();
        }

        public DocIdSet getDocIdSet(AtomicReaderContext ctx, Bits liveDocs) throws IOException {
            return this.filter.getDocIdSet(ctx, liveDocs);
        }
    }
}

