/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class HasChildFilterBuilder
extends BaseFilterBuilder {
    private final FilterBuilder filterBuilder;
    private final QueryBuilder queryBuilder;
    private String childType;
    private String filterName;
    private Integer shortCircuitCutoff;

    public HasChildFilterBuilder(String type, QueryBuilder queryBuilder) {
        this.childType = type;
        this.queryBuilder = queryBuilder;
        this.filterBuilder = null;
    }

    public HasChildFilterBuilder(String type, FilterBuilder filterBuilder) {
        this.childType = type;
        this.queryBuilder = null;
        this.filterBuilder = filterBuilder;
    }

    public HasChildFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public HasChildFilterBuilder cache(boolean cache) {
        return this;
    }

    public HasChildFilterBuilder cacheKey(String cacheKey) {
        return this;
    }

    public HasChildFilterBuilder setShortCircuitCutoff(int shortCircuitCutoff) {
        this.shortCircuitCutoff = shortCircuitCutoff;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("has_child");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        } else if (this.filterBuilder != null) {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        builder.field("child_type", this.childType);
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.shortCircuitCutoff != null) {
            builder.field("short_circuit_cutoff", this.shortCircuitCutoff);
        }
        builder.endObject();
    }
}

