/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigFloatArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.FloatArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.NonEstimatingEstimator;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public class FloatArrayIndexFieldData
extends AbstractIndexFieldData<FloatArrayAtomicFieldData>
implements IndexNumericFieldData<FloatArrayAtomicFieldData> {
    private final CircuitBreakerService breakerService;

    public FloatArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        this.breakerService = breakerService;
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.FLOAT;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        FloatArrayAtomicFieldData data = null;
        NonEstimatingEstimator estimator = new NonEstimatingEstimator(this.breakerService.getBreaker());
        if (terms == null) {
            data = FloatArrayAtomicFieldData.empty(reader.maxDoc());
            estimator.afterLoad(null, data.getMemorySizeInBytes());
            return data;
        }
        BigFloatArrayList values = new BigFloatArrayList();
        values.add(0.0f);
        float acceptableTransientOverheadRatio = this.fieldDataType.getSettings().getAsFloat("acceptable_transient_overhead_ratio", Float.valueOf(0.5f)).floatValue();
        OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), acceptableTransientOverheadRatio);
        boolean success = false;
        try {
            BytesRef term;
            BytesRefIterator iter = builder.buildFromTerms(this.getNumericType().wrapTermsEnum(terms.iterator(null)));
            while ((term = iter.next()) != null) {
                values.add(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)term)));
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long singleValuesArraySize = (long)(reader.maxDoc() * 4) + (set == null ? 0L : RamUsageEstimator.sizeOf((long[])set.getBits()) + 4L);
                long uniqueValuesArraySize = values.sizeInBytes();
                if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                    data = new FloatArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
                    success = true;
                    FloatArrayAtomicFieldData floatArrayAtomicFieldData = data;
                    return floatArrayAtomicFieldData;
                }
                int maxDoc = reader.maxDoc();
                BigFloatArrayList sValues = new BigFloatArrayList(maxDoc);
                for (int i = 0; i < maxDoc; ++i) {
                    sValues.add(values.get(ordinals.getOrd(i)));
                }
                assert (sValues.size() == (long)maxDoc);
                data = set == null ? new FloatArrayAtomicFieldData.Single(sValues, maxDoc, ordinals.getNumOrds()) : new FloatArrayAtomicFieldData.SingleFixedSet(sValues, maxDoc, set, ordinals.getNumOrds());
            } else {
                data = new FloatArrayAtomicFieldData.WithOrdinals(values, reader.maxDoc(), build);
            }
            success = true;
            FloatArrayAtomicFieldData floatArrayAtomicFieldData = data;
            return floatArrayAtomicFieldData;
        }
        finally {
            if (success) {
                estimator.afterLoad(null, data.getMemorySizeInBytes());
            }
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new FloatValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(Index index, @IndexSettings Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new FloatArrayIndexFieldData(index, indexSettings, mapper.names(), mapper.fieldDataType(), cache, breakerService);
        }
    }
}

