/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.ByteArray;

final class BigByteArray
extends AbstractBigArray
implements ByteArray {
    private byte[][] pages;

    public BigByteArray(long size, PageCacheRecycler recycler, boolean clearOnResize) {
        super(16384, recycler, clearOnResize);
        this.size = size;
        this.pages = new byte[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newBytePage(i);
        }
    }

    @Override
    public byte get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public byte set(long index, byte value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        byte[] page = this.pages[pageIndex];
        byte ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public void get(long index, int len, BytesRef ref) {
        assert (index + (long)len <= this.size());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        if (indexInPage + len <= this.pageSize()) {
            ref.bytes = this.pages[pageIndex];
            ref.offset = indexInPage;
            ref.length = len;
        } else {
            ref.bytes = new byte[len];
            ref.offset = 0;
            ref.length = this.pageSize() - indexInPage;
            System.arraycopy(this.pages[pageIndex], indexInPage, ref.bytes, 0, ref.length);
            do {
                int copyLength = Math.min(this.pageSize(), len - ref.length);
                System.arraycopy(this.pages[++pageIndex], 0, ref.bytes, ref.length, copyLength);
                ref.length += copyLength;
            } while (ref.length < len);
        }
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        assert (index + (long)len <= this.size());
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        if (indexInPage + len <= this.pageSize()) {
            System.arraycopy(buf, offset, this.pages[pageIndex], indexInPage, len);
        } else {
            int copyLen = this.pageSize() - indexInPage;
            System.arraycopy(buf, offset, this.pages[pageIndex], indexInPage, copyLen);
            do {
                copyLen = Math.min(len -= copyLen, this.pageSize());
                System.arraycopy(buf, offset += copyLen, this.pages[++pageIndex], 0, copyLen);
            } while (len > copyLen);
        }
    }

    @Override
    protected int numBytesPerElement() {
        return 1;
    }

    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (byte[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newBytePage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }
}

